package com.atlassian.fastdev;

import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

import static com.atlassian.fastdev.util.Option.option;

public class FastdevPropertiesImpl implements FastdevProperties, BundleContextAware
{
    private String fastdevVersion;

    public String getFastdevVersion()
    {
        return fastdevVersion;
    }

    public void setBundleContext(BundleContext bundleContext)
    {
        fastdevVersion = option(bundleContext.getBundle().getHeaders().get("Bundle-Version")).getOrElse("Unknown").toString();
    }
}
