/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.fastdev;

import com.atlassian.fastdev.ReloadHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoReloadFilter
implements Filter {
    private final Logger LOG = LoggerFactory.getLogger(AutoReloadFilter.class);
    private final ReloadHandler reloadHandler;
    private volatile boolean disabled = false;

    public AutoReloadFilter(ReloadHandler reloadHandler) {
        this.reloadHandler = (ReloadHandler)Preconditions.checkNotNull((Object)reloadHandler, (Object)"reloadHandler");
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (!this.disabled && this.isReloadablePath(req)) {
            if (req.getParameter("reload_die") != null) {
                this.LOG.info("Disabling auto-reload");
                this.disabled = true;
            } else if (this.isShiftReload(req)) {
                this.LOG.info("Reload detected, scanning for changes");
                Iterator<String> i$ = this.reloadHandler.reloadPlugins().iterator();
                if (i$.hasNext()) {
                    String output = i$.next();
                    response.setContentType("text/html;charset=utf-8");
                    response.getWriter().write(output);
                    return;
                }
            } else {
                this.LOG.info("No reload detected");
            }
        }
        chain.doFilter(request, response);
    }

    private boolean isReloadablePath(HttpServletRequest req) {
        String path = req.getRequestURI();
        return path.contains("plugins/servlet") || path.endsWith(".action") || path.endsWith(".jspa");
    }

    private boolean isShiftReload(HttpServletRequest req) {
        return "GET".equals(req.getMethod()) && StringUtils.indexOf((String)req.getHeader("X-Requested-With"), (String)"XMLHttpRequest") == -1 && ("no-cache".equals(req.getHeader("Pragma")) || StringUtils.indexOf((String)req.getHeader("User-Agent"), (String)"MSIE") != -1) && "no-cache".equals(req.getHeader("Cache-Control"));
    }

    public void destroy() {
    }
}

