/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.k8s.test;

import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFetcher
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LogFetcher.class);
    private final KubernetesClient client;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    LogFetcher(KubernetesClient client) {
        this.client = client;
    }

    public Future<String> waitForLog(String podName, String containerName, Predicate<String> logMatcher) {
        return this.executor.submit(() -> {
            try (LogWatch logWatch = this.getContainerLogWatcher(podName, containerName);){
                String string;
                block12: {
                    BufferedReader output = this.reader(logWatch);
                    try {
                        string = this.tail(output, podName, logMatcher);
                        if (output == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (output != null) {
                            try {
                                output.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    output.close();
                }
                return string;
            }
        });
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
    }

    private BufferedReader reader(LogWatch logWatch) {
        return new BufferedReader(new InputStreamReader(logWatch.getOutput(), StandardCharsets.UTF_8));
    }

    private String tail(BufferedReader output, String prefix, Predicate<String> test) throws IOException {
        String line;
        while ((line = output.readLine()) != null) {
            log.info(String.format("%s> %s", prefix, line));
            if (!test.test(line)) continue;
            return line;
        }
        return null;
    }

    private LogWatch getContainerLogWatcher(String podName, String containerName) {
        return (LogWatch)((ContainerResource)((PodResource)this.client.pods().withName(podName)).inContainer((Object)containerName)).watchLog();
    }
}

