/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.plugin.servlet;

import com.atlassian.jwt.core.JwtUtil;
import com.atlassian.jwt.plugin.sal.JwtAuthenticator;
import com.atlassian.sal.api.auth.AuthenticationController;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JwtAuthFilter
implements Filter {
    private final Authenticator authenticator;
    private final AuthenticationListener authenticationListener;
    private final AuthenticationController authenticationController;

    public JwtAuthFilter(AuthenticationListener authenticationListener, JwtAuthenticator authenticator, AuthenticationController authenticationController) {
        this.authenticationListener = authenticationListener;
        this.authenticator = authenticator;
        this.authenticationController = authenticationController;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.mayProceed(this.getHttpServletRequest(request), this.getHttpServletResponse(response))) {
            chain.doFilter(request, response);
        }
    }

    private HttpServletResponse getHttpServletResponse(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    private HttpServletRequest getHttpServletRequest(ServletRequest request) {
        return (HttpServletRequest)request;
    }

    private boolean mayProceed(HttpServletRequest request, HttpServletResponse response) {
        if (!this.authenticationController.shouldAttemptAuthentication(request)) {
            this.authenticationListener.authenticationNotAttempted(request, response);
            return true;
        }
        if (!JwtUtil.requestContainsJwt(request)) {
            this.authenticationListener.authenticationNotAttempted(request, response);
            return true;
        }
        Authenticator.Result result = this.authenticator.authenticate(request, response);
        if (result.getStatus() == Authenticator.Result.Status.FAILED) {
            this.authenticationListener.authenticationFailure(result, request, response);
            return false;
        }
        if (result.getStatus() == Authenticator.Result.Status.ERROR) {
            this.authenticationListener.authenticationError(result, request, response);
            return false;
        }
        this.authenticationListener.authenticationSuccess(result, request, response);
        this.markAsJwtRequest(request);
        return true;
    }

    private void markAsJwtRequest(HttpServletRequest request) {
        request.setAttribute("com.atlassian.jwt.is-jwt-request", (Object)true);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

