/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt.plugin.applinks;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.UnverifiedJwt;
import com.atlassian.jwt.applinks.ApplinkJwt;
import com.atlassian.jwt.applinks.JwtService;
import com.atlassian.jwt.applinks.exception.NotAJwtPeerException;
import com.atlassian.jwt.exception.JwtParseException;
import com.atlassian.jwt.exception.JwtSigningException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.plugin.applinks.SimpleApplinkJwt;
import com.atlassian.jwt.reader.JwtReader;
import com.atlassian.jwt.reader.JwtReaderFactory;
import com.atlassian.jwt.writer.JwtWriterFactory;

public class ApplinksJwtService
implements JwtService {
    private final JwtReaderFactory jwtReaderFactory;
    private final JwtWriterFactory jwtWriterFactory;
    private final ApplicationLinkService applicationLinkService;

    public ApplinksJwtService(JwtReaderFactory jwtReaderFactory, JwtWriterFactory jwtWriterFactory, ApplicationLinkService applicationLinkService) {
        this.jwtReaderFactory = jwtReaderFactory;
        this.jwtWriterFactory = jwtWriterFactory;
        this.applicationLinkService = applicationLinkService;
    }

    @Override
    public boolean isJwtPeer(ApplicationLink applicationLink) {
        return applicationLink.getProperty("atlassian.jwt.shared.secret") != null;
    }

    @Override
    public ApplinkJwt verifyJwt(String jwt) throws NotAJwtPeerException, JwtParseException, JwtVerificationException, TypeNotInstalledException {
        UnverifiedJwt unverifiedJwt = this.jwtReaderFactory.unverified().parse(jwt);
        String applicationId = unverifiedJwt.getIssuer();
        ApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(applicationId));
        JwtReader jwtReader = this.jwtReaderFactory.macVerifyingReader(this.requireSharedSecret(applicationLink));
        return new SimpleApplinkJwt(jwtReader.verify(jwt), applicationLink);
    }

    private String requireSharedSecret(ApplicationLink applicationLink) {
        String sharedSecret = (String)applicationLink.getProperty("atlassian.jwt.shared.secret");
        if (sharedSecret == null) {
            throw new NotAJwtPeerException(applicationLink);
        }
        return sharedSecret;
    }

    @Override
    public String issueJwt(String jsonPayload, ApplicationLink applicationLink) throws NotAJwtPeerException, JwtSigningException {
        return this.jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, this.requireSharedSecret(applicationLink)).jsonToJwt(jsonPayload);
    }
}

