/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jwt;

import com.atlassian.jwt.exception.JwsUnsupportedAlgorithmException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public enum SigningAlgorithm {
    HS256;


    public static SigningAlgorithm forName(String alg) throws JwsUnsupportedAlgorithmException {
        try {
            return SigningAlgorithm.valueOf(alg.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JwsUnsupportedAlgorithmException(alg + " is not a supported JWS algorithm. Please try one of: [" + StringUtils.join(Arrays.asList(SigningAlgorithm.values()), (String)",") + "]");
        }
    }
}

