package com.atlassian.json.jsonorg.marshal;

import com.atlassian.annotations.PublicApi;
import com.atlassian.json.jsonorg.JSONElement;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.json.marshal.JsonableMarshaller;

import java.io.IOException;
import java.io.Writer;

/**
 * A factory of {@link Jsonable}s based on {@link JSONElement} derived types.
 */
@PublicApi
public class JSONJsonableMarshaller implements JsonableMarshaller
{
    public Jsonable marshal(Object toJsonObj)
    {
        return marshal((JSONElement) toJsonObj);
    }

    /**
     * Returns a {@link Jsonable} object that can be turned into JSON via {@link JSONElement#write(java.io.Writer)}
     *
     * @param jsonElement the JSON element to wrap into a {@link Jsonable}
     * @return a {@link Jsonable}
     */
    public Jsonable marshal(final JSONElement jsonElement)
    {
        return new Jsonable()
        {
            public void write(Writer writer) throws IOException
            {
                if (jsonElement == null || JSONObject.NULL.equals(jsonElement))
                {
                    writer.write("null");
                }
                else
                {
                    try
                    {
                        jsonElement.write(writer);
                    }
                    catch (JSONException e)
                    {
                        // the JSON class make IO exceptions into its own exceptions but we don't want that.
                        if (e.getCause() instanceof IOException)
                        {
                            throw (IOException) e.getCause();
                        }
                        throw new JsonMappingException(e);
                    }
                }
            }
        };
    }
}
