package com.atlassian.json.jsonorg;

import com.atlassian.annotations.PublicApi;

import java.io.Writer;

/**
 * A base class for the top level JSON classes
 */
@PublicApi
public abstract class JSONElement
{
    /**
     * @return true if the element is in fact a {@link JSONObject}
     */
    public abstract boolean isJSONObject();

    /**
     * @return true if the element is in fact a {@link JSONArray}
     */
    public abstract boolean isJSONArray();

    /**
     * @return the element as a {@link JSONObject}
     */
    public abstract JSONObject getAsJSONObject();

    /**
     * @return the element as a {@link JSONObject}
     */
    public abstract JSONArray getAsJSONArray();

    /**
     * Allos the object to be written out as JSON
     *
     * @param writer the writer to put the JSON on
     * @return the Writer itself
     * @throws JSONException if an exceptions happen during reading or writing the JSON
     */
    public abstract Writer write(final Writer writer) throws JSONException;
}
