package com.atlassian.json.marshal;

import com.atlassian.annotations.PublicApi;

import java.io.IOException;
import java.io.Writer;

/**
 * Any object the implements {@link Jsonable} knows how to convert itself into JSON and write itself to a {@link java.io.Writer}.
 * <p>
 * This interface is intended to allow the object in question to be responsible for what marshaling service to use.
 * <p>
 * It can use JAXB, Jackson, GSON or StringBuilder but it takes responsibility for getting itself onto a JSON stream .
 * <p>
 * There is a {@link JsonableMarshaller} interface to help you create wrapper objects for you data values.
 *
 */
@PublicApi
public interface Jsonable
{
    /**
     * Called to write the object out in JSON format
     *
     * @param writer the place to write the JSON to
     * @throws java.io.IOException if the writer can't be written to
     * @throws JsonMappingException if the underlying object can't be mapped to JSON
     */
    void write(Writer writer) throws IOException;

    /**
     * This can be thrown if an object is in a state that means it cant be mapped to JSON
     */
    public static class JsonMappingException extends RuntimeException {

        public JsonMappingException(Throwable cause)
        {
            super(cause);
        }
    }
}
