package com.atlassian.json.marshal.wrapped;

import com.atlassian.json.marshal.Jsonable;

import java.io.IOException;
import java.io.Writer;

/**
 * Base superclass for converting Java representations of raw JSON types (eg String, Number, Boolean) to Jsonable.
 * @since v0.9
 */
public abstract class WrappingJsonable<T> implements Jsonable
{
    private final T value;

    public WrappingJsonable(T value)
    {
        this.value = value;
    }

    @Override
    public void write(Writer writer) throws IOException
    {
        writer.write(null == value ? "null" : convertValueToString(value));
    }

    protected abstract String convertValueToString(T value);
}
