/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.spring.lifecycle;

import com.atlassian.johnson.spring.lifecycle.LifecycleState;
import com.atlassian.johnson.spring.lifecycle.LifecycleUtils;
import com.atlassian.johnson.spring.web.context.support.JohnsonHttpRequestHandlerServlet;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LifecycleHttpRequestHandlerServlet
extends JohnsonHttpRequestHandlerServlet {
    private volatile boolean starting = true;

    @Override
    public void init() throws ServletException {
        LifecycleState state = LifecycleUtils.getCurrentState(this.getServletContext());
        if (state == LifecycleState.STARTED) {
            this.starting = false;
            super.init();
        }
    }

    @Override
    protected void service(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws ServletException, IOException {
        if (this.starting) {
            if (LifecycleUtils.isStarting(this.getServletContext())) {
                this.sendRedirect(response);
                return;
            }
            this.starting = false;
        }
        super.service(request, response);
    }
}

