/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.ExpandableProperty;
import com.atlassian.jira.rest.client.domain.BasicUser;
import com.atlassian.jira.rest.client.domain.User;
import com.atlassian.jira.rest.client.internal.json.JsonParseUtil;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.ArrayList;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class UserJsonParser
implements JsonParser<User> {
    @Override
    public User parse(JSONObject json) throws JSONException {
        BasicUser basicUser = JsonParseUtil.parseBasicUser(json);
        URI avatarUri = JsonParseUtil.parseURI(json.getString("avatarUrl"));
        String emailAddress = json.getString("emailAddress");
        ExpandableProperty<String> groups = JsonParseUtil.parseExpandableProperty(json.getJSONObject("groups"), new JsonParser<String>(){

            @Override
            public String parse(JSONObject json) throws JSONException {
                return json.getString("name");
            }
        });
        ArrayList<String> groupList = new ArrayList<String>();
        if (groups.getSize() > 0) {
            Iterables.addAll(groupList, groups.getItems());
        }
        return new User(basicUser.getSelf(), basicUser.getName(), basicUser.getDisplayName(), emailAddress, avatarUri, groupList);
    }
}

