/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.json;

import com.atlassian.jira.rest.client.domain.IssueLinkType;
import com.atlassian.jira.rest.client.internal.json.JsonParser;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class IssueLinkTypeJsonParser
implements JsonParser<IssueLinkType> {
    private static final String KEY_DIRECTION = "direction";

    @Override
    public IssueLinkType parse(JSONObject json) throws JSONException {
        IssueLinkType.Direction direction;
        String name = json.getString("name");
        String description = json.getString("description");
        String dirStr = json.getString(KEY_DIRECTION);
        if ("OUTBOUND".equals(dirStr)) {
            direction = IssueLinkType.Direction.OUTBOUND;
        } else if ("INBOUND".equals(dirStr)) {
            direction = IssueLinkType.Direction.INBOUND;
        } else {
            throw new JSONException("Invalid value of direction key: [" + dirStr + "]");
        }
        return new IssueLinkType(name, description, direction);
    }
}

