AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.TransitionConnection",{allPortsAreVisible:function(A){return this.checkPortsVisibility(A,[])},checkPortsVisibility:function(A,B){return _.all(A.getPorts(),function(C,D){if(_.contains(B,D)){return !C.isVisible()}return C.isVisible()})},createTestData:function(A){this.sourceView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel({x:10,y:0}),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel(),isPortDragged:jQuery.noop,getAllTargetPorts:_.bind(this._getAllPorts,this)}).render();this.targetView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel({x:200,y:0}),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel(),isPortDragged:jQuery.noop,getAllTargetPorts:_.bind(this._getAllPorts,this)}).render();this.transitionConnection=new JIRA.WorkflowDesigner.TransitionConnection(!!A);this.transitionConnection.installEditPolicy(new JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy());this.transitionConnection.setSource(this.sourceView.getPorts()[0]);this.transitionConnection.setTarget(this.targetView.getPorts()[0]);this.canvas.addFigure(this.transitionConnection)},_getAllPorts:function(){return _.union(this.sourceView.getPorts(),this.targetView.getPorts())},selectTransition:function(){this.canvas.selectFigure(this.transitionConnection)},setup:function(){function A(){return new draw2d.geo.Rectangle(0,0,0,0)}this.sandbox=sinon.sandbox.create();this.canvas=JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();this.selectionPolicy=new JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy(A)},teardown:function(){this.sandbox.restore()}});test("Changing source port should relocate the transition label",function(){var A;this.createTestData();A=this.sandbox.stub(JIRA.WorkflowDesigner.Layout.Locator.ManhattanPercentageLocator.prototype,"relocate");this.transitionConnection.setSource(this.sourceView.getPorts()[0]);equal(A.callCount,1,"relocate() should be called once")});test("Changing target port should relocate the transition label",function(){var A;this.createTestData();A=this.sandbox.stub(JIRA.WorkflowDesigner.Layout.Locator.ManhattanPercentageLocator.prototype,"relocate");this.transitionConnection.setTarget(this.sourceView.getPorts()[0]);equal(A.callCount,1,"relocate() should be called once")});test("Label text is truncated if maximum length is exceeded",function(){var A=new JIRA.WorkflowDesigner.TransitionConnection();A._getEllipsis=sinon.stub().returns("\u2026");A.setText(null);equal(A._label.getText(),undefined,"Null label stays null");A.setText("12345");equal(A._label.getText(),"12345","Label shorter than maximum is not truncated");A.setText("123456789 123456789 123456789 ");equal(A._label.getText(),"123456789 123456789 123456789 ","Label equal to maximum is not truncated");A.setText("123456789 123456789 123456789 123456789");equal(A._label.getText(),"123456789 123456789 123456789\u2026","Label longer than maximum is truncated and ellipsis is appended")});test("Transitions should have a gap",function(){var A=new JIRA.WorkflowDesigner.TransitionConnection(false);sinon.stub(A,"getTarget").returns({getConnectionDirection:function(){return JIRA.WorkflowDesigner.Direction.RIGHT}});sinon.stub(A,"getSource").returns({getConnectionDirection:function(){return JIRA.WorkflowDesigner.Direction.RIGHT}});deepEqual(A.getEndPointGapTransformation(),{x:3,y:0},"The end point should have a gap of 3 pixels");deepEqual(A.getStartPointGapTransformation(),{x:3,y:0},"The start point should have a gap of 3 pixels")});test("Global Transitions should have a gap only in the endpoint",function(){var A=new JIRA.WorkflowDesigner.TransitionConnection(true);sinon.stub(A,"getTarget").returns({getConnectionDirection:function(){return JIRA.WorkflowDesigner.Direction.RIGHT}});sinon.stub(A,"getSource").returns({getConnectionDirection:function(){return JIRA.WorkflowDesigner.Direction.RIGHT}});deepEqual(A.getEndPointGapTransformation(),{x:3,y:0},"The end point should have a gap of 3 pixels");deepEqual(A.getStartPointGapTransformation(),{x:0,y:0},"The start point should have a gap of 3 pixels")});test("Status target ports are shown when connection start/end is dragged",function(){var C,B,A;this.createTestData();this.selectTransition();B=this.transitionConnection.selectionHandles;A=B.get(0);C=B.get(1);ok(jQuery(A.shape).is(":visible"),"Start resize handler is visible");ok(jQuery(C.shape).is(":visible"),"End resize handler is visible");ok(!this.allPortsAreVisible(this.sourceView),"All ports in the source are not visible before drag");ok(!this.allPortsAreVisible(this.targetView),"All ports in the target are not visible before drag");A.onDragStart();ok(this.allPortsAreVisible(this.sourceView),"When resizing from the start, all ports in the source are visible on drag");ok(!this.allPortsAreVisible(this.targetView),"When resizing from the start, all ports in the target are not visible on drag");A.onDragEnd();ok(!this.allPortsAreVisible(this.sourceView),"When resizing from the start, all ports in the source are not visible after drag");ok(!this.allPortsAreVisible(this.targetView),"When resizing from the start, all ports in the target are not visible after drag");C.onDragStart();ok(this.checkPortsVisibility(this.sourceView,[0]),"When resizing from the end, all ports in the source except the opposite port are visible on drag");ok(this.allPortsAreVisible(this.targetView),"When resizing from the end, all ports in the target are visible on drag");C.onDragEnd();ok(!this.allPortsAreVisible(this.sourceView),"When resizing from the end, all ports in the source are not visible after drag");ok(!this.allPortsAreVisible(this.targetView),"When resizing from the end, all ports in the target are not visible after drag")});test("Connection's port is hidden when the opposite port is dragged",function(){var C,D,B,A,E;C=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:new JIRA.WorkflowDesigner.StatusModel({x:10,y:0}),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel(),isPortDragged:jQuery.noop,getAllTargetPorts:function(){return C.getPorts()}}).render();D=new JIRA.WorkflowDesigner.TransitionConnection(false);D.installEditPolicy(new JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy());D.setSource(C.getPorts()[0]);D.setTarget(C.getPorts()[1]);this.canvas.addFigure(D);this.canvas.selectFigure(D);B=D.selectionHandles;A=B.get(0);E=B.get(1);A.onDragStart();ok(this.checkPortsVisibility(C,[1]),"When resizing from the start, all ports except the port #1 are visible");A.onDragEnd();E.onDragStart();ok(this.checkPortsVisibility(C,[0]),"When resizing from the start, all ports except the port #0 are visible");E.onDragEnd()});test("The label is always visible on the Initial transitions",function(){this.createTestData(true);ok(this.transitionConnection.textIsVisible(),"The transition's label is visible")});test("Start resize handler is not visible on Initial transition",function(){this.createTestData(true);this.selectTransition();ok(!jQuery(this.transitionConnection.selectionHandles.get(0).shape).is(":visible"),"Start resize handler is invisible");ok(jQuery(this.transitionConnection.selectionHandles.get(1).shape).is(":visible"),"End resize handler is visible")});test("Clicking a transition's label selects the transition",function(){this.createTestData();sinon.stub(this.canvas,"getBestFigure").returns(this.transitionConnection._label);this.selectionPolicy.onMouseDown(this.canvas,0,0);ok(this.canvas.getSelectedFigure()===this.transitionConnection,"The transition was selected")});test("Line start handle's onDragEnd operation does nothing when moused over a drop target and dropped on nothing",function(){var B,A;this.createTestData();this.selectTransition();A=this.sourceView.getPorts()[0];B=this.transitionConnection.selectionHandles.get(0);B.onDragStart();var C=this.sandbox.stub(B,"_getDropTarget").returns(this.sourceView.getPorts()[1]);B.onDrag(0,0);C.returns(null);B.onDrag(0,0);B.onDragEnd();ok(this.transitionConnection.getSource()===A,"The source port should revert back to the original port.")});test("Line start handle's onDragEnd undoes operation when dropped on a drop target",function(){var A,B;this.createTestData();this.selectTransition();B=this.sourceView.getPorts()[1];A=this.transitionConnection.selectionHandles.get(0);A.onDragStart();this.sandbox.stub(A,"_getDropTarget").returns(B);A.onDrag(0,0);A.onDragEnd();ok(this.transitionConnection.getSource()===B,"The source after drag end should be the moused over port.")});test("#positionArrow sets the target decorator's z-index",function(){var A;this.createTestData();A=sinon.spy(this.transitionConnection.targetDecoratorNode,"insertAfter");this.transitionConnection.positionArrow();equal(A.callCount,1,"The target decorator's insertAfter method was called");ok(A.args[0][0]===this.transitionConnection.shape,"It was passed the correct argument")});