AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.LineResizeHandleMixin", {
    setup: function() {
        this.sandbox = sinon.sandbox.create();
        this.repaintStub = this.sandbox.stub(draw2d.shape.basic.LineResizeHandle.prototype, "repaint");
    },

    teardown: function() {
        this.sandbox.restore();
    },

    createMixinInstance: function() {
        var F = function(){
            this.init.apply(this, arguments);
        };
        F.prototype = JIRA.WorkflowDesigner.LineResizeHandleMixin;
        var instance = new F();

        instance.x = 20;
        instance.y = 0;
        instance.getGap = function() {return {x: 1, y: 2};};

        return instance;
    }
});

test("setPosition() should center the actionable area", function () {
    var lineResizeHandle = this.createMixinInstance();
    lineResizeHandle.width = 10;
    lineResizeHandle.height = 10;

    lineResizeHandle.setPosition();

    equal(lineResizeHandle._actionableArea.x, 15, "The actionable area is centered in the horizontal axis");
    equal(lineResizeHandle._actionableArea.y, -5, "The actionable area is centered in the vertical axis");
});

test("repaint() applies the gap to the handler", function() {
    var lineResizeHandle = this.createMixinInstance();
    lineResizeHandle.getGap = function() {return {x: 1, y: 2};};
    lineResizeHandle.repaint();

    equal(lineResizeHandle.x, 19, "The handler has a horizontal gap");
    equal(lineResizeHandle.y, -2, "The handler has a vertical gap");
});

test("repaint() is called with the right attributes the gap to the handler", function() {
    var lineResizeHandle = this.createMixinInstance();
    lineResizeHandle.repaint();

    var expectedAttributes =  {
        "cursor": "crosshair",
        "fill": "#333333",
        "stroke": "#333333"
    };
    deepEqual(this.repaintStub.firstCall.args[0], expectedAttributes, "repaint() is called with the right attributes");
});

test("Actionable area has default attributes", function() {
    var lineResizeHandle = this.createMixinInstance();
    var expectedAttributes =  {
        "cursor": "crosshair",
        "fill-opacity": 0,
        "stroke-opacity": 0
    };
    deepEqual(lineResizeHandle._actionableAreaAttributes, expectedAttributes, "Actionable Area has the right default attributes");
});