(function (Backbone) {
    var StatusDialogView = JIRA.WorkflowDesigner.Dialogs.StatusDialogView;

    Backbone.define("JIRA.WorkflowDesigner.Dialogs.CreateStatusDialogView", JIRA.WorkflowDesigner.Dialogs.StatusDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.CreateStatusDialogView# */
    {
        id: "create-status-dialog",

        template: JIRA.WorkflowDesigner.Templates.createStatusDialog,

        ui: function () {
            return _.extend({}, StatusDialogView.prototype.ui, {
                createGlobalTransition: "#create-global-transition-create"
            });
        },

        /**
         * Initialise the dialog.
         *
         * @constructs
         * @classdesc The workflow designer's "Create Status" dialog.
         * @extends JIRA.WorkflowDesigner.Dialogs.StatusDialogView
         * @param {object} options
         * @param {boolean} [options.createGlobalTransition=false] Whether the global transition checkbox should be checked.
         * @param {JIRA.WorkflowDesigner.StatusModel} options.statusModel The application's `StatusModel`.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The application's `WorkflowModel`.
         */
        initialize: function (options) {
            options = _.defaults({}, options, {
                createGlobalTransition: false
            });

            StatusDialogView.prototype.initialize.apply(this, arguments);
            this._createGlobalTransition = options.createGlobalTransition;
        },

        /**
         * Make a request to create the status.
         *
         * @return {jQuery.Deferred} A deferred that is resolved on success.
         * @private
         */
        _makeRequest: function (options) {
            options = _.extend({}, options, {
                createGlobalTransition: this.ui.createGlobalTransition.is(":checked")
            });

            return JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager.createStatus(options);
        },

        /**
         * Override the onSuccess function to reset the workflow mode.
         * @param layoutData
         * @private
         */
        _onSuccess: function (layoutData) {
            var duration = new Date() - this._workflowModel.get("loadedAt");

            JIRA.WorkflowDesigner.Analytics.triggerAddStatus();
            JIRA.WorkflowDesigner.Analytics.triggerAddStep();
            JIRA.WorkflowDesigner.Analytics.triggerFirstAddStatus(duration);
            this.hide();
            this._workflowModel.reset(layoutData);
        },

        /**
         * @returns {object} Data for the view's template.
         */
        serializeData: function () {
            var data = StatusDialogView.prototype.serializeData.apply(this, arguments);
            return _.extend(data, {createGlobalTransition: this._createGlobalTransition});
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));