AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.AddStatusInlineDialogView",{assertOption:function(A,C,B){A=jQuery(A);equal(A.text(),C,"The option contains the correct text");equal(A.val(),B,"The option contains the correct value")},checkCreateGlobalTransition:function(A){A.ui.createGlobalTransition.attr("checked","");A.ui.createGlobalTransition.change()},createDialog:function(A){A=_.defaults({},A,{trigger:jQuery("<div>"),workflowModel:new JIRA.WorkflowDesigner.WorkflowModel()});return new JIRA.WorkflowDesigner.Dialogs.AddStatusInlineDialogView(A)},selectStatus:function(B,C,A){B.ui.statusName.trigger("selected",new AJS.ItemDescriptor({fieldText:A,label:A,value:C}))},setup:function(){var B=jQuery.Deferred(),A=this.sandbox=sinon.sandbox.create(),D=JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager,C=JIRA.WorkflowDesigner.IO.AJAX.WorkflowStatusesAJAXManager;B.resolve([{id:"closed",name:"Closed"},{id:"open",name:"Open"}]);this.addStatusDeferred=jQuery.Deferred();this.addStatusStub=A.stub(C,"addStatus").returns(this.addStatusDeferred);this.getStatusesStub=A.stub(D,"getStatuses").returns(B)},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});asyncTest("A CreateStatusDialogView is shown if the new status option was selected",function(){var B={show:sinon.spy()},E=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"CreateStatusDialogView").returns(B),C,A=this,D=new JIRA.WorkflowDesigner.WorkflowModel();C=this.createDialog({workflowModel:D});this.sandbox.spy(C,"_cancel");C.show().done(function(){A.selectStatus(C,"","New Status");C.$(":submit").click();equal(E.callCount,1,"A CreateStatusDialogView was created");equal(E.args[0][0].statusModel.get("name"),"New Status","It was passed a StatusModel with the correct name");ok(E.args[0][0].workflowModel===D,"It was passed the correct WorkflowModel");equal(B.show.callCount,1,"It was shown");equal(C._cancel.callCount,1,"The AddStatusInlineDialogView was hidden and reset");start()})});asyncTest("An error message is shown if adding a status fails",function(){var C=this.createDialog(),B=sinon.spy(),A=this;C.on("done",B);C.show().done(function(){var E=jQuery.Deferred(),D,F="No status for you!";C.$(":submit").click();A.addStatusDeferred.reject(F);D=C.$(".aui-message.error");equal(B.callCount,1,"A done event was triggered");equal(D.length,1,"An error message is shown in the inline dialog");equal(D.text(),F,"It contains the correct message");equal(C.$(":disabled").length,0,"No inputs are disabled");A.addStatusStub.returns(E);C.$(":submit").click();equal(C.$(".aui-message.error").length,0,"Error messages are removed while submitting");E.resolve({});start()})});test("An error message is shown if statuses fail to load",function(){var C=this.createDialog(),A="No statuses for you!",B=this.sandbox.stub(JIRA.WorkflowDesigner.Messages,"showErrorMessage");this.getStatusesStub.returns(jQuery.Deferred().reject(A));C.show();equal(B.callCount,1,"An error message was shown");equal(B.args[0][0],A,"The correct error message was shown")});asyncTest("Clicking a status name suggestion doesn't close the dialog",function(){var A=this.createDialog();this.sandbox.spy(A,"hide");A.show().done(function(){A._statusName._handleCharacterInput(true);A._statusName.dropdownController.layer().click();equal(A.hide.callCount,0,"The dialog wasn't hidden");start()})});asyncTest("Clicking cancel closes and resets the dialog",function(){var B=this.createDialog(),A=this;this.sandbox.spy(B,"hide");B.show().done(function(){A.checkCreateGlobalTransition(B);A.selectStatus(B,"open","Open");B.$(".cancel").click();equal(B.hide.callCount,1,"The dialog was hidden");B.show().done(function(){equal(B.$(":selected").val(),"closed","The selected status was cleared");ok(!B.ui.createGlobalTransition.is(":checked"),"The create global transition checkbox was unchecked");start()})})});asyncTest("Clicking the document doesn't close the dialog while it's submitting",function(){var B=this.createDialog(),A=this,C=B._inlineDialog.getOptions().preHideCallback;B.show().done(function(){ok(C(),"The inline dialog will close before submission");B.$(":submit").click();ok(!C(),"The inline dialog won't close while submitting");A.addStatusDeferred.resolve({});start()})});asyncTest("No error appears if the message is empty",function(){var A=this.createDialog();this.addStatusDeferred.reject();A.show().done(function(){A.ui.submit.click();equal(A.$(".aui-message.error").length,0,"No error message appeared");start()})});asyncTest("Submission is ignored if no status is selected",function(){var C=this.sandbox.spy(JIRA.WorkflowDesigner.Dialogs,"CreateStatusDialogView"),B=this.createDialog(),A=this;this.getStatusesStub.returns(jQuery.Deferred().resolve([]));B.show().done(function(){B.ui.form.submit();equal(C.callCount,0,"No CreateStatusDialogView was created");equal(A.addStatusStub.callCount,0,"WorkflowStatusesAJAXManager.addStatus wasn't called");start()})});asyncTest("Submitting the form adds a status to the workflow",function(){var D,C=sinon.spy(),F,A=this,H={},G=this.sandbox.spy(JIRA.WorkflowDesigner.IO.AJAX.StatusesAJAXManager,"reset"),B=sinon.spy(),E;E=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow"});this.sandbox.stub(E,"reset");D=this.createDialog({workflowModel:E});D.on({done:C,submit:B});this.sandbox.spy(D,"hide");F=[{createGlobalTransition:false,statusId:"closed",workflowName:"Workflow"}];D.show().done(function(){var I;D.$(":submit").click();I=D.$(":input:visible");equal(I.filter(":disabled").length,I.length,"All inputs are disabled");equal(A.addStatusStub.callCount,1,"WorkflowStatusesAJAXManager.addStatus was called");deepEqual(A.addStatusStub.args[0],F,"It was passed the correct options");equal(B.callCount,1,"A submit event was triggered");A.addStatusDeferred.resolve(H);equal(D.hide.callCount,1,"The dialog was hidden");equal(C.callCount,1,"A done event was triggered");equal(E.reset.callCount,1,"The WorkflowModel was reset");ok(E.reset.args[0][0]===H,"It was passed the correct layout data");equal(G.callCount,1,"StatusesAJAXManager was reset");start()})});asyncTest('The "create global transition" checkbox is respected',function(){var B,D,A=this,C=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow"});B=this.createDialog({workflowModel:C});D=[{createGlobalTransition:true,statusId:"closed",workflowName:"Workflow"}];B.show().done(function(){B.ui.createGlobalTransition.attr("checked","");B.ui.submit.click();equal(A.addStatusStub.callCount,1,"WorkflowStatusesAJAXManager.addStatus was called");deepEqual(A.addStatusStub.args[0],D,"It was passed the correct options");A.addStatusDeferred.resolve({});start()})});asyncTest('The "create global transition" checkbox state is passed to the create status dialog',function(){var B=this.sandbox.spy(JIRA.WorkflowDesigner.Dialogs,"CreateStatusDialogView"),C=this.createDialog(),A=this;C.show().done(function(){A.selectStatus(C,"","New Status");C.ui.createGlobalTransition.attr("checked","");C.ui.submit.click();equal(B.callCount,1,"A CreateStatusDialogView was created");ok(B.args[0][0].createGlobalTransition,"It was passed the state of the create global transition checkbox");start()})});asyncTest('The "create global transition" checkbox state is persisted between shows',function(){var B=this.createDialog(),A=this;B.show().done(function(){A.checkCreateGlobalTransition(B);B.hide();B.show().done(function(){ok(B.ui.createGlobalTransition.is(":checked"),"The state was persisted");start()})})});asyncTest("The dialog appears after its content fails to load",function(){var A=this.createDialog(),B=this.getStatusesStub;B.returns(jQuery.Deferred().reject());A.show().done(function(){ok(!A.$el.is(":visible"),"The dialog isn't visible");B.returns(jQuery.Deferred().resolve([]));A.show().done(function(){ok(A.$el.is(":visible"),"The dialog is visible");start()})})});asyncTest("The dialog is reset after submission",function(){var B=this.createDialog(),A=this;B.show().done(function(){A.checkCreateGlobalTransition(B);A.selectStatus(B,"open","Open");B.ui.submit.click();A.addStatusDeferred.resolve({});B.show().done(function(){equal(B.$(":selected").val(),"closed","The selected status was cleared");ok(!B.ui.createGlobalTransition.is(":checked"),"The create global transition checkbox was unchecked");start()})})});asyncTest("The selected new status is persisted across shows",function(){var B=this.createDialog(),A=this;B.show().done(function(){A.selectStatus(B,"","New Status");B.hide();B.show().done(function(){A.assertOption(B.$(":selected"),"New Status","");start()})})});asyncTest("The selected status is persisted across shows",function(){var B=this.createDialog(),A=this;B.show().done(function(){A.selectStatus(B,"open","Open");B.hide();B.show().done(function(){equal(B.$(":selected").val(),"open","The selected status was persisted");start()})})});asyncTest("The submit button is initially disabled if no existing statuses are available",function(){var B,A=this;this.getStatusesStub.returns(jQuery.Deferred().resolve([]));B=this.createDialog();B.show().done(function(){equal(B.$(":disabled:submit").length,1,"The submit button is disabled initially");A.selectStatus(B,"","New Status");equal(B.$(":disabled:submit").length,0,"The submit button is enabled after selecting a new status");B.ui.statusName.trigger("unselect");equal(B.$(":disabled:submit").length,1,"The submit button is disabled after clearing the selection");start()})});asyncTest("Triggers analytics events after successfully adding an existing status",function(){var A=this.createDialog(),C=this.sandbox.spy(JIRA.WorkflowDesigner.Analytics,"triggerAddStep"),B=this.sandbox.spy(JIRA.WorkflowDesigner.Analytics,"triggerFirstAddStatus");this.addStatusDeferred.resolve({});A.show().done(function(){A.$(":submit").click();equal(C.callCount,1,"An add step event was triggered");equal(B.callCount,1,"A first add status event was triggered");start()})});asyncTest("Valid statuses are listed in the dialog",function(){var D,C=jQuery.Deferred(),A=this,B,F,E;this.getStatusesStub.returns(C);E=new JIRA.WorkflowDesigner.WorkflowModel();E.addStatus({statusId:"in-progress"});D=this.createDialog({workflowModel:E});F=D.show();equal(this.getStatusesStub.callCount,1,"StatusesAJAXManager.getStatuses was called");C.resolve([{id:"in-progress",name:"In Progress"},{id:"open",name:"Open"},{id:"closed",name:"Closed"}]);F.done(function(){B=D.$("#status-name option");equal(B.length,2,"The correct number of options are present");A.assertOption(B[0],"Closed","closed");A.assertOption(B[1],"Open","open");start()})});