AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Dialogs.EditTransitionSourceDialogView",{setup:function(){this.canvas=JIRA.WorkflowDesigner.TestUtilities.testDraw2DCanvas();this.sandbox=sinon.sandbox.create();this.updateTransitionSourceStub=this.sandbox.stub(JIRA.WorkflowDesigner.IO.AJAX.WorkflowTransitionsAJAXManager,"updateTransitionSource");this.createWorkflowModel();this.createStatusModelsAndViews();this.createTransitionModelsAndViews()},createWorkflowModel:function(){this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel({name:"Workflow Name"});this.workflowModel.updateTransitionSource=this.sandbox.spy()},createStatusModelsAndViews:function(){this.originalSourceStatus=this.workflowModel.addStatus({stepId:1,name:"Source"});this.sourceView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:this.originalSourceStatus,workflowModel:this.workflowModel}).render();this.targetView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:this.workflowModel.addStatus({stepId:2,name:"Target"}),workflowModel:this.workflowModel}).render();this.newSourceView=new JIRA.WorkflowDesigner.StatusView({canvas:this.canvas,model:this.workflowModel.addStatus({stepId:3,name:"New source"}),workflowModel:this.workflowModel}).render();this.sourcePort=this.newSourceView.getPorts()[0]},createTransitionModelsAndViews:function(){this.transitionModel=this.workflowModel.addTransition({actionId:1,source:this.sourceView.model,target:this.targetView.model,targetAngle:90});this.transitionView=new JIRA.WorkflowDesigner.TransitionView({canvas:this.canvas,canvasModel:new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel}),model:this.transitionModel,sourceView:this.sourceView,targetView:this.targetView,workflowModel:this.workflowModel}).render();this.transitionView.resetConnection=this.sandbox.spy()},showDialog:function(){new JIRA.WorkflowDesigner.Dialogs.EditTransitionSourceDialogView({newSourcePort:this.sourcePort,newSourceView:this.newSourceView,originalSourceStatus:this.originalSourceStatus,transitionView:this.transitionView,workflowModel:this.workflowModel}).show();return JIRA.Dialog.current&&JIRA.Dialog.current.get$popup()},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.sandbox.restore()}});test("Editing transition source",function(){var A=jQuery.Deferred(),B=this.showDialog(),C=this.newSourceView.getAngleToPort(this.sourcePort);ok(JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog is visible");ok(B.find(":submit").length,"The dialog has a submit button");this.updateTransitionSourceStub.returns(A.promise());JIRA.WorkflowDesigner.TestUtilities.submit(B);equal(B.find(":input:disabled").length,B.find(":input").length,"All inputs are disabled while submitting");equal(this.updateTransitionSourceStub.callCount,1,"WorkflowTransitionsAJAXManager.updateTransitionSource() was called");A.resolve();equal(this.workflowModel.updateTransitionSource.callCount,1,"WorkflowModel.updateTransitionSource was called");deepEqual(this.workflowModel.updateTransitionSource.args[0][0],{transition:this.transitionModel,sourceAngle:C,sourceStepId:3},"It was passed the correct arguments");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog closed")});test("An error message is shown if updating the transition source fails",function(){var C=this.showDialog(),A,B="Oh noes!";this.updateTransitionSourceStub.returns(jQuery.Deferred().reject(B).promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);A=C.find(".aui-message.error");equal(A.length,1,"An error message is shown in the dialog");ok(A.text().indexOf(B)>-1,"It contains the correct text");equal(C.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateTransitionSourceStub.returns(jQuery.Deferred().promise());JIRA.WorkflowDesigner.TestUtilities.submit(C);equal(C.find(".error").length,0,"Errors are removed on submit")});test("Closing the dialog resets transition target",function(){var A=this.showDialog();ok(JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog is visible");A.find("#cancel").click();equal(this.transitionView.resetConnection.callCount,1,"Transition target was reset");ok(!JIRA.WorkflowDesigner.TestUtilities.dialogIsVisible(),"The dialog closed")});