AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.CanvasView",{setup:function(){this.sandbox=sinon.sandbox.create();this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel();this.canvasModel=new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel});this.canvasView=JIRA.WorkflowDesigner.TestUtilities.testCanvasView({canvasModel:this.canvasModel,workflowModel:this.workflowModel});this.canvas=this.canvasView.canvas},teardown:function(){JIRA.WorkflowDesigner.TestUtilities.removeDialogs();this.canvasView.remove();this.sandbox.restore()},triggerKeyDown:function(B,A){A=_.extend({which:B},A);jQuery(document).trigger(jQuery.Event("keydown",A))}});test("Adding a connection displays an AddTransitionDialogView",function(){var B=new draw2d.Connection(),C={show:sinon.spy()},A=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"AddTransitionDialogView").returns(C),D,E;E=new JIRA.WorkflowDesigner.TransitionModel({source:this.workflowModel.addStatus(),target:this.workflowModel.addStatus()});B.setSource(this.canvasView.statusViews.at(0).getPorts()[0]);B.setTarget(this.canvasView.statusViews.at(1).getPorts()[0]);sinon.spy(this.canvas,"removeFigure");this.sandbox.stub(JIRA.WorkflowDesigner,"TransitionModel").returns(E);this.canvasView.canvas.onNewConnection(B);D=[{transitionModel:E,workflowModel:this.workflowModel}];equal(A.callCount,1,"An AddTransitionDialogView was created");ok(A.args[0][0].canvasModel===this.canvasModel,"It was passed the correct canvas model");ok(A.args[0][0].transitionModel===E,"It was passed the correct transition model");ok(A.args[0][0].workflowModel===this.workflowModel,"It was passed the correct workflow model");equal(C.show.callCount,1,"It was shown");ok(this.canvas.removeFigure.calledWith(B),"The connection was removed from the canvas");equal(this.workflowModel.get("transitions").length,0,"No TransitionModel was added to the WorkflowModel")});test("addStatus()",function(){var C=this.sandbox.spy(JIRA.WorkflowDesigner,"InitialStatusView"),B=new JIRA.WorkflowDesigner.StatusModel(),A=this.sandbox.spy(JIRA.WorkflowDesigner,"StatusView");this.canvasView.addStatus(B);equal(C.callCount,0,"No InitialStatusView was created for a normal status");equal(A.callCount,1,"A StatusView was created for a normal status");equal(A.args[0][0].model,B,"It is associated with the given model");B.set("initial",true);this.canvasView.addStatus(B);equal(C.callCount,1,"An InitialStatusView was created for an initial status");equal(C.args[0][0].model,B,"It is associated with the given model");equal(A.callCount,1,"No StatusView was created for an initial status")});test("addStatus() selects the new status if necessary",function(){var B=this.sandbox.spy(JIRA.WorkflowDesigner.StatusView.prototype,"select"),A;A=new JIRA.WorkflowDesigner.StatusModel();this.canvasView.addStatus(A);equal(B.callCount,0,"The status wasn't selected");A=new JIRA.WorkflowDesigner.StatusModel();this.canvasModel.set("selectedModel",A);this.canvasView.addStatus(A);equal(B.callCount,1,"The status was selected")});test("addTransition()",function(){var A=this.workflowModel.addStatus({}),B,C=this.sandbox.spy(JIRA.WorkflowDesigner,"TransitionView");B=this.workflowModel.addTransition({name:"Transition",source:A,target:A});this.canvasView.addTransition(B);equal(C.callCount,1,"A new TransitionView was created");equal(C.args[0][0].model,B,"It is associated with the given model");this.canvasView.addTransition(B);equal(C.callCount,1,"Attempting to add duplicate transitions does nothing")});test("addTransition() selects the new transition if necessary",function(){var A=this.sandbox.spy(JIRA.WorkflowDesigner.TransitionView.prototype,"select"),B;B=new JIRA.WorkflowDesigner.TransitionModel({source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});this.canvasView.addTransition(B);equal(A.callCount,0,"The transition wasn't selected");B=new JIRA.WorkflowDesigner.TransitionModel({source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});this.canvasModel.set("selectedModel",B);this.canvasView.addTransition(B);equal(A.callCount,1,"The transition was selected")});test("getCanvasBoundingBox() doesn't include LayerRootFigures",function(){var A;this.canvasView.canvas.getFigures=function(){return new draw2d.util.ArrayList([new JIRA.WorkflowDesigner.Draw2DCanvas.LayerRootFigure(),JIRA.WorkflowDesigner.TestMocks.figure([10,10,10,10])])};A=new draw2d.geo.Rectangle(10,10,10,10);ok(A.equals(this.canvasView.getCanvasBoundingBox()),"The bounding box was calculated correctly")});test("getCanvasBoundingBox() includes relevant figures and lines",function(){var A;this.canvasView.canvas.getFigures=function(){return new draw2d.util.ArrayList(_.map([[-10,-10,5,5],[0,0,5,5],[10,10,5,5]],JIRA.WorkflowDesigner.TestMocks.figure))};this.canvasView.canvas.getLines=function(){return new draw2d.util.ArrayList(_.map([[-8,-15,13,18],[-3,3,13,18],[-5,-8,23,13]],JIRA.WorkflowDesigner.TestMocks.figure))};A=new draw2d.geo.Rectangle(-10,-15,28,36);ok(A.equals(this.canvasView.getCanvasBoundingBox()),"The bounding box was calculated correctly")});test("WorkflowModel StatusCollection observation",function(){var C=this.sandbox.spy(this.canvasView,"removeStatus"),B,A=this.sandbox.spy(JIRA.WorkflowDesigner,"StatusView");B=this.workflowModel.addStatus({});equal(A.callCount,1,"Adding a StatusModel causes a StatusView to be created");equal(A.args[0][0].model,B,"It is associated with the new StatusModel");this.workflowModel.reset({statuses:[],transitions:[]});ok(C.callCount===1&&C.args[0][0]===B,"Removing a StatusModel causes its StatusView to be removed")});test("WorkflowModel TransitionCollection observation",function(){var D=this.sandbox.spy(this.canvasView,"removeTransition"),A,B,C=this.sandbox.spy(JIRA.WorkflowDesigner,"TransitionView");A=this.workflowModel.addStatus({});B=this.workflowModel.addTransition({name:"Transition",source:A,target:A});equal(C.callCount,1,"Adding a TransitionModel causes a TransitionView to be created");equal(C.args[0][0].model,B,"It is associated with the new TransitionModel");this.workflowModel.reset({statuses:[],transitions:[]});ok(D.callCount===1&&D.args[0][0]===B,"Removing a TransitionModel causes its TransitionView to be removed")});test("Transition reconnection updates the TransitionModel if target status was not changed",function(){var A=this.workflowModel.addStatus({x:0,y:100}),G=this.canvasView.addStatus(A),D,B=this.workflowModel.addStatus(),E=this.canvasView.addStatus(B),F,C;F=this.workflowModel.addTransition({name:"Transition",source:B,sourceAngle:90,target:A,targetAngle:-90});C=this.canvasView.addTransition(F);C._connection.setSource(E.getPortForAngle(0));C._connection.setTarget(G.getPortForAngle(0));C.trigger("reconnect",C);D={source:B,sourceAngle:E.getAngleToPort(C._connection.getSource()),target:A,targetAngle:G.getAngleToPort(C._connection.getTarget())};deepEqual(_.pick(F.attributes,"source","sourceAngle","target","targetAngle"),D,"The TransitionModel's sourceAngle and targetAngle attributes were updated")});test("Transition reconnection shows EditTransitionTargetDialogView if target status was changed",function(){var E=this.workflowModel.addStatus({x:0,y:100}),I,A=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"EditTransitionTargetDialogView"),D=this.workflowModel.addStatus(),B=this.canvasView.addStatus(D),F=this.workflowModel.addStatus(),C=this.canvasView.addStatus(F),G,H;A.returns({show:jQuery.noop});G=this.workflowModel.addTransition({name:"Transition",source:D,sourceAngle:90,target:E,targetAngle:-90});H=this.canvasView.addTransition(G);H._connection.setSource(B.getPortForAngle(0));H._connection.setTarget(C.getPortForAngle(0));H.trigger("reconnect",H);I={targetPort:C.getPortForAngle(0),targetView:C,transitionView:H,workflowModel:this.workflowModel};equal(A.callCount,1,"An EditTransitionTargetDialogView was created");ok(_.isEqual(A.args[0][0],I),"It was passed the correct arguments")});test("Transition reconnection shows EditTransitionSourceDialogView if source status was changed",function(){var A=this.workflowModel.addStatus({x:0,y:100}),D,F=this.sandbox.stub(JIRA.WorkflowDesigner.Dialogs,"EditTransitionSourceDialogView"),B=this.workflowModel.addStatus(),H=this.workflowModel.addStatus(),E=this.canvasView.addStatus(H),G,C;F.returns({show:jQuery.noop});G=this.workflowModel.addTransition({name:"Transition",source:B,sourceAngle:90,target:A,targetAngle:-90});C=this.canvasView.addTransition(G);C._connection.setSource(E.getPortForAngle(0));C.trigger("reconnect",C);D={newSourcePort:E.getPortForAngle(0),newSourceView:E,originalSourceStatus:B,transitionView:C,workflowModel:this.workflowModel};equal(F.callCount,1,"An EditTransitionSourceDialogView was created");ok(_.isEqual(F.args[0][0],D),"It was passed the correct arguments")});test("Statuses without coordinates are positioned automatically",function(){var C=sinon.spy(),D=new JIRA.WorkflowDesigner.StatusModel({x:10,y:10}),B=new JIRA.WorkflowDesigner.StatusModel({x:200,y:200}),E=new JIRA.WorkflowDesigner.StatusModel(),A=new JIRA.WorkflowDesigner.StatusModel();this.workflowModel.on("layoutChanged",C);this.workflowModel.reset({statuses:[D,B,E,A],transitions:[]});ok(_.isNumber(E.get("x")),"The first model has an x coordinate");ok(_.isNumber(E.get("y")),"The first model has a y coordinate");ok(_.isNumber(A.get("x")),"The second model has an x coordinate");ok(_.isNumber(A.get("y")),"The second model has a y coordinate");ok(C.called,"Triggered a layoutChanged event")});test("Autocalculated transition ports must trigger autosaving",function(){var B=sinon.spy(),C=new JIRA.WorkflowDesigner.StatusModel({x:10,y:10}),D=new JIRA.WorkflowDesigner.StatusModel({x:200,y:200}),A;A=new JIRA.WorkflowDesigner.TransitionModel({name:"Transition",source:C,target:D,ports:null});this.workflowModel.on("layoutChanged",B);this.workflowModel.reset({statuses:[C,D],transitions:[A]});ok(B.called,"Triggered a layoutChanged event")});test("Zooming with the mouse wheel hides the current inline dialog",function(){this.sandbox.stub(AJS,"InlineDialog");AJS.InlineDialog.current={hide:sinon.spy()};sinon.stub(this.canvasView,"getCanvasBoundingBox").returns(new draw2d.geo.Rectangle(0,0,0,0));this.canvasView._zoomHandler.trigger("zoom",{clientX:10,clientY:10,factor:1.05});equal(AJS.InlineDialog.current.hide.callCount,1,"The current inline dialog was hidden")});test("The canvas is resized after its container is resized",function(){JIRA.WorkflowDesigner.TestUtilities.fakeTimer(function(C){var E=JIRA.WorkflowDesigner.TestUtilities.testCanvasView({model:this.workflowModel});var D=E.$el.width();var B=E.$el.height();C.tick(150);equal(D,E.canvas.svgElement.width());equal(B,E.canvas.svgElement.height());var A=function(){equal(E.$el.width(),E.canvas.svgElement.width());equal(E.$el.height(),E.canvas.svgElement.height())};E.$el.width(D*0.5);E.$el.height(B*0.5);C.tick(150);A();E.$el.width(D);E.$el.height(B);C.tick(150);A();E.remove()},this)});test("Deleting the selected transition",function(){var C,A=[jQuery.ui.keyCode.BACKSPACE,jQuery.ui.keyCode.DELETE],B;this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});B=this.canvasView.transitionViews.at(0);this.canvas.selectFigure(B._connection);C=this.sandbox.stub(B,"destroy");_.each(A,function(D){this.triggerKeyDown(D);equal(C.callCount,1,"TransitionView.destroy() was called for key code "+D);C.reset()},this)});test("Deleting the selected status",function(){var C,B=[jQuery.ui.keyCode.BACKSPACE,jQuery.ui.keyCode.DELETE],A;this.workflowModel.addStatus({x:0,y:100});A=this.canvasView.statusViews.at(0);this.canvas.selectFigure(A._figure);C=this.sandbox.stub(A,"destroy");_.each(B,function(D){this.triggerKeyDown(D);equal(C.callCount,1,"StatusView.destroy() was called for key code "+D);C.reset()},this)});test("Deletion is disabled when a dialog is visible",function(){var F,D=[jQuery.ui.keyCode.BACKSPACE,jQuery.ui.keyCode.DELETE],B,A,C,E;jQuery("#qunit-fixture").append('<div class="aui-blanket">');C=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});E=this.canvasView.addTransition(C).render();this.canvas.selectFigure(E._connection);F=this.sandbox.stub(E,"destroy");_.each(D,function(G){this.triggerKeyDown(G);equal(F.callCount,0,"TransitionView.destroy() was not called")},this);B=this.workflowModel.addStatus({x:0,y:100});A=this.canvasView.addStatus(B).render();A.select();F=this.sandbox.stub(A,"destroy");_.each(D,function(G){this.triggerKeyDown(G);equal(F.callCount,0,"StatusView.destroy() was not called")},this)});test("Deletion is disabled when the view is locked",function(){var A;this.canvasView.setLocked(true);this.workflowModel.addStatus({x:0,y:0});A=this.canvasView.statusViews.at(0);A.select();this.sandbox.stub(A,"destroy");this.triggerKeyDown(jQuery.ui.keyCode.BACKSPACE);equal(A.destroy.callCount,0,"StatusView#destroy wasn't called")});test("Pressing delete key when target is an input does not display a DeleteTransitionDialogView",function(){var D,B=[jQuery.ui.keyCode.BACKSPACE,jQuery.ui.keyCode.DELETE],A,C;A=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});C=this.canvasView.addTransition(A).render();this.canvas.selectFigure(C._connection);D=this.sandbox.stub(C,"destroy");_.each(B,function(E){this.triggerKeyDown(E,{target:jQuery("<input>")});equal(D.callCount,0,"TransitionView.destroy() was not called")},this)});test("Auto-fitting fits the SVG element to its container",function(){sinon.spy(this.canvasView.canvas,"fitToContainer");this.canvasView.autoFit();equal(this.canvasView.canvas.fitToContainer.callCount,1,"Canvas#fitToContainer() was called")});test("Auto-fitting centers the diagram if it fits into default bounds",function(){var A=sinon.spy(this.canvasView.canvas,"setViewBox");this.canvasView.$el.width(500);this.canvasView.$el.height(200);this.canvasView.canvas.getFigures=function(){return new draw2d.util.ArrayList([JIRA.WorkflowDesigner.TestMocks.figure([-10,-10,25,25])])};this.canvasView.autoFit();ok(A.args[0][0].equals(new draw2d.geo.Rectangle(-247.5,-97.5,500,200)),"View box dimensions were not changed and the diagram was centered")});test("Auto-fitting scales and centers the diagram if it doesn't fit into default bounds",function(){var A=sinon.spy(this.canvasView.canvas,"setViewBox");this.canvasView.$el.width(500);this.canvasView.$el.height(200);sinon.stub(this.canvasView.canvas,"getViewBox").returns(new draw2d.geo.Rectangle(-20,-20,620,350));this.canvasView.canvas.getFigures=function(){return new draw2d.util.ArrayList([JIRA.WorkflowDesigner.TestMocks.figure([-10,-10,600,300])])};this.canvasView.autoFit();ok(A.args[1][0].equals(new draw2d.geo.Rectangle(-20,-35,620,350)),"View box was scaled and the diagram was centered")});test("Auto-fitting sets the CanvasModel's zoomLevel property",function(){this.canvasView.addStatus(new JIRA.WorkflowDesigner.StatusModel());ok(!this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property isn't set");this.canvasView.autoFit();ok(this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property is set");equal(this.canvasModel.get("zoomLevel"),this.canvasView.canvas.getZoom(),"It is set to the canvas zoom level")});test("setResizeInterval()",function(){var A=this.sandbox.spy(JIRA.WorkflowDesigner.Draw2DCanvas.prototype,"setResizeInterval");this.canvasView.setResizeInterval(42);equal(A.callCount,1,"JIRA.WorkflowDesigner.Draw2DCanvas#setResizeInterval() was called");deepEqual(A.args[0],[42],"It was passed the correct arguments")});test("Selects views in response to the CanvasModel's selectedModel property changing",function(){var B=this.sandbox.spy(JIRA.WorkflowDesigner.StatusView.prototype,"_onSelect"),A=this.workflowModel.addStatus({});this.canvasModel.set("selectedModel",A);equal(B.callCount,1,"The view was selected")});test("Updates the CanvasModel in response to view (de)selection",function(){var B=this.workflowModel.addStatus({}),A=this.canvasView.statusViews.at(0);A.select();ok(this.canvasModel.get("selectedModel")===B,"The CanvasModel's selectedModel property was updated");ok(this.canvasModel.get("selectedView")===A,"The CanvasModel's selectedView property was updated");A.deselect();ok(!this.canvasModel.has("selectedModel"),"The CanvasModel's selectedModel property was cleared");ok(!this.canvasModel.has("selectedView"),"The CanvasModel's selectedView property was cleared")});test("Source view is updated when model source is updated",function(){var C,A,B;A=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});B=this.canvasView._getTransitionViewWithModel(A);this.sandbox.spy(B,"resetConnection");C=this.workflowModel.addStatus({});A.set("source",C);ok(B._getSourceView()===this.canvasView._getStatusViewWithModel(C),"Source view was updated");equal(B.resetConnection.callCount,1,"Connection was reset")});test("Target view is updated when model target is updated",function(){var C,A,B;A=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});B=this.canvasView._getTransitionViewWithModel(A);this.sandbox.spy(B,"resetConnection");C=this.workflowModel.addStatus({});A.set("target",C);ok(B._getTargetView()===this.canvasView._getStatusViewWithModel(C),"Target view was updated");equal(B.resetConnection.callCount,1,"Connection was reset")});test("Zooming sets the CanvasModel's zoomLevel property",function(){this.canvasView.addStatus(new JIRA.WorkflowDesigner.StatusModel());ok(!this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property isn't set");this.canvasView.zoom(1);ok(this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property is set");equal(this.canvasModel.get("zoomLevel"),this.canvasView.canvas.getZoom(),"It is set to the canvas zoom level")});test("When a transition is (de)selected, its siblings are (de)selected",function(){var E=this.workflowModel.addStatus({id:1}),D=this.workflowModel.addStatus({id:2}),C=this.workflowModel.addStatus({id:3}),A,I,B,H,F,G;A=this.workflowModel.addTransition({actionId:"2",source:C,target:D});B=this.workflowModel.addTransition({actionId:"1",source:C,target:E});F=this.workflowModel.addTransition({actionId:"1",source:D,target:E});I=this.canvasView._getTransitionViewWithModel(A);H=this.canvasView._getTransitionViewWithModel(B);G=this.canvasView._getTransitionViewWithModel(F);this.sandbox.spy(I,"appearSelected");this.sandbox.spy(H,"appearSelected");G.trigger("selected",G);equal(I.appearSelected.callCount,0,"Non-sibling transitions aren't selected");equal(H.appearSelected.callCount,1,"Sibling transitions are selected");this.sandbox.spy(I,"unhighlight");this.sandbox.spy(H,"unhighlight");G.trigger("deselected",G);equal(I.unhighlight.callCount,0,"Non-sibling transitions aren't deselected");equal(H.unhighlight.callCount,1,"Sibling transitions are deselected")});