(function (Backbone) {
    Backbone.define("JIRA.WorkflowDesigner.ZoomControlView", Backbone.Marionette.ItemView.extend(
    /** @lends JIRA.WorkflowDesigner.ZoomControlView# */
    {
        className: "zoom-control",

        events: {
            "click .zoom-in": "_triggerZoomIn",
            "click .zoom-out": "_triggerZoomOut"
        },

        modelEvents: {
            "change:zoomLevel": "_debouncedRender"
        },

        template: JIRA.WorkflowDesigner.Templates.zoomControl,

        /**
         * @class
         * @classdesc A widget to control the workflow designer's zoom level.
         * @constructs
         * @extends Backbone.Marionette.ItemView
         * @param {object} options
         * @param {number} options.maximumZoomLevel The control's maximum zoom level.
         * @param {number} options.minimumZoomLevel The control's minimum zoom level.
         */
        initialize: function (options) {
            this._debouncedRender = _.debounce(this.render, 100);
            this._maximumZoomLevel = options.maximumZoomLevel;
            this._minimumZoomLevel = options.minimumZoomLevel;
        },

        /**
         * Serialize data for the view's template.
         */
        serializeData: function () {
            var epsilon = 0.001,
                zoomLevel = this.model.get("zoomLevel");

            return {
                zoomInDisabled: zoomLevel >= this._maximumZoomLevel - epsilon,
                zoomOutDisabled: zoomLevel <= this._minimumZoomLevel + epsilon
            };
        },

        /**
         * Trigger a "zoomIn" event.
         *
         * @private
         */
        _triggerZoomIn: function () {
            this.trigger("zoomIn");
        },

        /**
         * Trigger a "zoomOut" event.
         *
         * @private
         */
        _triggerZoomOut: function () {
            this.trigger("zoomOut");
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));