(function () {
    AJS.namespace("JIRA.WorkflowDesigner.StatusPositioner");

    /**
     * Calculates and sets status positions.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.StatusPositioner = {
        /**
         * Position statuses that don't have coordinates yet.
         *
         * @param {JIRA.WorkflowDesigner.StatusView[]} statusViews The statuses to position.
         * @param {draw2d.geo.Rectangle} viewBox The canvas's view box.
         */
        positionStatuses: function (statusViews, viewBox) {
            var positionCentre,
                top;

            positionCentre = new draw2d.geo.Point(
                viewBox.getCenter().getX(),
                viewBox.getY() + viewBox.getHeight() * 0.2
            );

            function calculateTop(statusViews) {
                var groupHeight = _.sum(_.map(statusViews, getHeight));
                top = positionCentre.getY() - groupHeight / 2;
            }

            function positionStatusView(statusView) {
                statusView.setPosition(positionCentre.getX() - statusView.getBoundingBox().getWidth() / 2, top);
                top += getHeight(statusView);
            }

            _.chain(statusViews).reject(hasCoordinates).tap(calculateTop).each(positionStatusView);
        }
    };

    /**
     * @inner
     * @param {JIRA.WorkflowDesigner.StatusView} statusView A <tt>StatusView</tt>.
     * @return {number} <tt>statusView</tt>'s height.
     */
    function getHeight(statusView) {
        return statusView.getBoundingBox().getHeight();
    }

    /**
     * @inner
     * @param {JIRA.WorkflowDesigner.StatusView} statusView A <tt>StatusView</tt>.
     * @return {boolean} Whetheer <tt>statusView</tt>'s model has coordinates.
     */
    function hasCoordinates(statusView) {
        return statusView.model.hasCoordinates();
    }
}());