(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Messages");

    /**
     * Message-related utility methods.
     *
     * @namespace
     */
    JIRA.WorkflowDesigner.Messages = {
        /**
         * Show a global, persistent error message.
         *
         * @param {string} message The message to show.
         * @param {object} [options]
         * @param {boolean} [options.closeable=false] Whether the error message can be closed.
         * @param {number} [options.timeout=0] The time before the message fades out.
         * @returns {jQuery} The error message element.
         */
        showErrorMessage: function (message, options) {
            var errorMessage;

            options = _.defaults({}, options, {
                closeable: true,
                timeout: 0
            });

            if (message) {
                errorMessage = JIRA.Messages.showErrorMsg(message, options);
                errorMessage.css("z-index", 2510);
            }

            return errorMessage;
        }
    };
}());