AJS.test.require("jira.webresources:jira-global");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:feedback");

module("JIRA.WorkflowDesigner.Feedback", {
    setup: function () {
        this.sandbox = sinon.sandbox.create();
    },

    teardown: function () {
        this.sandbox.restore();
    }
});

test("Clicking feedback trigger after successful initialisation shows Issue Collector dialog", function () {
    var trigger = jQuery("<a>");

    this.sandbox.stub(jQuery, "ajax", function(input) {
        input.success();
    });

    var deferred = JIRA.WorkflowDesigner.Feedback.init(trigger, "test");

    equal(deferred.state(), "resolved", "The returned deferred is resolved on success");

    var showCollectorDialogSpy = sinon.spy();

    window.ATL_JQ_PAGE_PROPS.test.triggerFunction(showCollectorDialogSpy);

    trigger.click();

    ok(showCollectorDialogSpy.called, "Dialog shown");
});

test("Unsuccessful initialisation rejects the deferred result", function () {
    this.sandbox.stub(jQuery, "ajax", function(input) {
        input.error();
    });

    var deferred = JIRA.WorkflowDesigner.Feedback.init(jQuery("<a>"), "test");

    equal(deferred.state(), "rejected", "The returned deferred is rejected on failure");
});