AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.WorkflowModel",{setup:function(){this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel();this.sandbox=sinon.sandbox.create()},teardown:function(){this.sandbox.restore()}});test("addStatus()",function(){var B,A,C=this.workflowModel.get("statuses");B={description:"",id:"id",stepId:42,statusCategory:null,statusId:"42",name:"Status",initial:false,x:42,y:1337};A=this.workflowModel.addStatus({id:"id",stepId:42,statusId:"42",name:"Status",x:42,y:1337});ok(A instanceof JIRA.WorkflowDesigner.StatusModel,"The new StatusModel was returned");deepEqual(B,A.attributes,"Its attributes are correct");ok(C.length===1&&C.at(0)===A,"It was added to the StatusCollection")});test("addTransition()",function(){var A,B=new JIRA.WorkflowDesigner.StatusModel({id:"source"}),D=new JIRA.WorkflowDesigner.StatusModel({id:"target"}),E,C=this.workflowModel.get("transitions");A={id:"A<1:source:target>",actionId:1,description:null,globalTransition:false,name:"Transition",source:B,sourceAngle:90,target:D,targetAngle:-90,screenId:null,screenName:null,propertiesCount:1,conditionsCount:2,validatorsCount:3,postFunctionsCount:4};E=this.workflowModel.addTransition({actionId:1,globalTransition:false,name:"Transition",source:B,sourceAngle:90,target:D,targetAngle:-90,propertiesCount:1,conditionsCount:2,validatorsCount:3,postFunctionsCount:4});ok(E instanceof JIRA.WorkflowDesigner.TransitionModel,"The new TransitionModel was returned");deepEqual(E.attributes,A,"Its attributes are correct");ok(C.length===1&&C.at(0)===E,"It was added to the WorkflowModel's TransitionCollection")});test("addTransition() global transition",function(){var B,A=new JIRA.WorkflowDesigner.StatusModel({id:"status"}),D,C=this.workflowModel.get("transitions");B={id:"A<1:status:status>",actionId:1,description:"Resolve the issue!",globalTransition:true,name:"Resolve",source:A,sourceAngle:null,target:A,targetAngle:null,screenName:"Resolve View",screenId:2,propertiesCount:1,conditionsCount:2,validatorsCount:3,postFunctionsCount:4};D=this.workflowModel.addTransition({actionId:1,description:"Resolve the issue!",globalTransition:true,name:"Resolve",source:A,target:A,screenName:"Resolve View",screenId:2,propertiesCount:1,conditionsCount:2,validatorsCount:3,postFunctionsCount:4});ok(D instanceof JIRA.WorkflowDesigner.TransitionModel,"The new TransitionModel was returned");deepEqual(D.attributes,B,"Its attributes are correct");ok(C.length===1&&C.at(0)===D,"It was added to the WorkflowModel's TransitionCollection")});test("getGlobalTransitionForStatus()",function(){var B,A=this.workflowModel.addStatus({});ok(this.workflowModel.getGlobalTransitionForStatus(A)===undefined,"Returns undefined when the status doesn't have a global transition");B=this.workflowModel.addTransition({globalTransition:true,target:A});ok(this.workflowModel.getGlobalTransitionForStatus(A)===B,"Returns the correct TransitionModel when the status has a global transition")});test("getStatus()",function(){var A;ok(this.workflowModel.getStatus("open")===undefined,"Returns undefined when no status is found");A=this.workflowModel.addStatus({id:"open"});ok(this.workflowModel.getStatus("open")===A,"Returns the correct StatusModel when a status is found")});test("reset() doesn't trigger new:* events on initial load",function(){var A=sinon.spy();this.workflowModel.on("new:status new:transition",A);this.workflowModel.reset({statuses:[new JIRA.WorkflowDesigner.StatusModel()],transitions:[new JIRA.WorkflowDesigner.TransitionModel()]});equal(A.callCount,0,"No new:* events were triggered")});test("reset() resets the model to a given state",function(){var A,B,C=this.workflowModel.get("statuses"),E,D=this.workflowModel.get("transitions");equal(C.length,0,"The model contains no statuses");equal(D.length,0,"The model contains no transitions");A=new JIRA.WorkflowDesigner.StatusModel({name:"Closed"});B=new JIRA.WorkflowDesigner.StatusModel({name:"Open"});E=new JIRA.WorkflowDesigner.TransitionModel({name:"Close",source:B,target:A});this.workflowModel.reset({statuses:[A,B],transitions:[E]});equal(C.length,2,"The model contains the correct number of statuses");equal(D.length,1,"The model contains the correct number of transitions");this.workflowModel.reset({draft:true,name:"Different Name",statuses:[],transitions:[]});equal(this.workflowModel.get("draft"),true,"The model's draft status is correct");equal(this.workflowModel.get("name"),"Different Name","The model's name is correct");equal(C.length,0,"The model contains the correct number of statuses");equal(D.length,0,"The model contains the correct number of transitions")});test("reset() triggers a new:status event if there is a single new status",function(){var A=new JIRA.WorkflowDesigner.StatusModel({id:"Closed"}),C=new JIRA.WorkflowDesigner.StatusModel({id:"In Progress"}),B=new JIRA.WorkflowDesigner.StatusModel({id:"Open"}),E=new JIRA.WorkflowDesigner.StatusModel({id:"Pull Request"}),D=sinon.spy();this.workflowModel.addStatus(A);this.workflowModel.on("new:status",D);this.workflowModel.reset({statuses:[A,C],transitions:[]});equal(D.callCount,1,"A new:status event is triggered when there is a single new status");ok(D.args[0][0]===C,"The new status was passed as an argument");this.workflowModel.reset({statuses:[A,C,B,E],transitions:[]});equal(D.callCount,1,"No new:status event is triggered when there are multiple new statuses")});test("reset() triggers a new:transition event if there is a single new transition",function(){var E=new JIRA.WorkflowDesigner.TransitionModel({id:"Closed"}),A=new JIRA.WorkflowDesigner.TransitionModel({id:"Pull Request"}),B=sinon.spy(),D=new JIRA.WorkflowDesigner.TransitionModel({id:"In Progress"}),C=new JIRA.WorkflowDesigner.TransitionModel({id:"Open"});this.workflowModel.addTransition(E);this.workflowModel.on("new:transition",B);this.workflowModel.reset({statuses:[],transitions:[E,A]});equal(B.callCount,1,"A new:transition event is triggered when there is a single new transition");ok(B.args[0][0]===A,"The new transition was passed as an argument");this.workflowModel.reset({statuses:[],transitions:[E,A,D,C]});equal(B.callCount,1,"No new:transition event is triggered when there are multiple new transitions")});test("Triggers a layoutChanged event when status coordinates change",function(){var B=sinon.spy(),A;A=this.workflowModel.addStatus({id:"id",name:"Status",stepId:1,x:0,y:0});this.workflowModel.bind("layoutChanged",B);A.set({x:0,y:0});ok(!B.called,"A layoutChanged event wasn't triggered");A.set({x:10,y:10});ok(B.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition action ID changes value",function(){var A=sinon.spy(),B=this.workflowModel.addTransition({actionId:1});this.workflowModel.bind("layoutChanged",A);B.set({actionId:1});ok(!A.called,"A layoutChanged event wasn't triggered");B.set({actionId:2});ok(A.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition angles change",function(){var A=sinon.spy(),B=this.workflowModel.addTransition({sourceAngle:90,targetAngle:-90});this.workflowModel.bind("layoutChanged",A);B.set({sourceAngle:90,targetAngle:-90});ok(!A.called,"A layoutChanged event wasn't triggered");B.set({sourceAngle:0,targetAngle:180});ok(A.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition target changes",function(){var B=sinon.spy(),A=this.workflowModel.addStatus(),C=this.workflowModel.addTransition({target:A});this.workflowModel.bind("layoutChanged",B);C.set("target",A);ok(!B.called,"A layoutChanged event wasn't triggered");C.set("target",this.workflowModel.addStatus());ok(B.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition model is destroyed",function(){var A=sinon.spy(),B=this.workflowModel.addTransition({actionId:1});this.workflowModel.bind("layoutChanged",A);B.destroy();ok(A.called,"A layoutChanged event was triggered")});test("statusHasGlobalTransition() returns false when status has no transitions",function(){var A=new JIRA.WorkflowDesigner.StatusModel({id:1});this.workflowModel.reset({statuses:[A]});ok(!this.workflowModel.statusHasGlobalTransition(A),"Should return false when no transitions")});test("statusHasGlobalTransition() returns false when status has only normal transitions",function(){var E,A,C,B,D;A=new JIRA.WorkflowDesigner.StatusModel({id:1});C=new JIRA.WorkflowDesigner.StatusModel({id:2});B=new JIRA.WorkflowDesigner.StatusModel({id:3});E=new JIRA.WorkflowDesigner.TransitionModel({actionId:1,source:B,target:A});D=new JIRA.WorkflowDesigner.TransitionModel({actionId:2,source:B,target:C});this.workflowModel.reset({statuses:[A,C,B],transitions:[E,D]});ok(!this.workflowModel.statusHasGlobalTransition(C),"Should return false when only normal transitions")});test("statusHasGlobalTransition() returns true when status has only global transition",function(){var B,A;A=new JIRA.WorkflowDesigner.StatusModel({id:1});B=new JIRA.WorkflowDesigner.TransitionModel({actionId:1,target:A,globalTransition:true});this.workflowModel.reset({statuses:[A],transitions:[B]});ok(this.workflowModel.statusHasGlobalTransition(A),"Should return true when only a global transition")});test("statusHasGlobalTransition() returns true when status has global transition and normal transitions",function(){var F,A,D,C,B,E;A=new JIRA.WorkflowDesigner.StatusModel({id:1});C=new JIRA.WorkflowDesigner.StatusModel({id:2});B=new JIRA.WorkflowDesigner.StatusModel({id:3});F=new JIRA.WorkflowDesigner.TransitionModel({actionId:1,source:B,target:A});E=new JIRA.WorkflowDesigner.TransitionModel({actionId:2,source:B,target:C});D=new JIRA.WorkflowDesigner.TransitionModel({actionId:3,target:C,globalTransition:true});this.workflowModel.reset({statuses:[A,C,B],transitions:[F,E,D]});ok(this.workflowModel.statusHasGlobalTransition(C),"Should return true when normal transitions and a global transition")});test("Draft workflow status that exists on the live workflow is not deletable",function(){var A=this.workflowModel.addStatus({stepId:1});this.workflowModel.set({draft:true,liveStepIds:[1]});ok(!this.workflowModel.statusIsDeletable(A),"Status is non-deletable")});test("Draft workflow status that doesn't exists on the live workflow is deletable",function(){var A=this.workflowModel.addStatus({stepId:1});this.workflowModel.set({draft:true,liveStepIds:[2]});ok(this.workflowModel.statusIsDeletable(A),"Status is deletable")});test("All live workflow statuses are deletable",function(){var A=this.workflowModel.addStatus({stepId:1});this.workflowModel.set({liveStepIds:[1]});ok(this.workflowModel.statusIsDeletable(A),"Status is deletable")});test("updateTransitionTargets sets the passed step on all transitions with the passed action ID",function(){var A=this.workflowModel.addStatus({stepId:1}),C=this.workflowModel.addTransition({actionId:2}),B=this.workflowModel.addTransition({actionId:2});this.sandbox.spy(C,"setTarget");this.sandbox.spy(B,"setTarget");this.workflowModel.updateTransitionTargets({targetAngle:0,targetStepId:1,transition:C});equal(C.setTarget.callCount,1,"setTarget of the first transition was called");equal(C.setTarget.args[0][0],A,"It was passed the correct target");equal(C.setTarget.args[0][1],0,"It was passed the correct target angle");equal(B.setTarget.callCount,1,"setTarget of the second transition was called");equal(B.setTarget.args[0][0],A,"It was passed the correct target");ok(!B.setTarget.args[0][1],"It was passed the correct target angle")});test("updateTransitionSource sets the new source",function(){var A=this.workflowModel.addStatus({stepId:1}),B=this.workflowModel.addTransition({actionId:2});this.sandbox.spy(B,"setSource");this.workflowModel.updateTransitionSource({sourceAngle:0,sourceStepId:1,transition:B});equal(B.setSource.callCount,1,"setSource of the first transition was called");equal(B.setSource.args[0][0],A,"It was passed the correct source");equal(B.setSource.args[0][1],0,"It was passed the correct source angle")});