AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.TransitionModel", {
    createTransition: function(options) {
        options = options || {};

        var source = new JIRA.WorkflowDesigner.StatusModel({id: "source", initial: options.initial}),
            target = new JIRA.WorkflowDesigner.StatusModel({id: "target"});

        return new JIRA.WorkflowDesigner.TransitionModel({
            actionId: 1,
            source: source,
            target: target
        });
    }
});

test("getSourceStepId() returns null when source isn't set", function () {
    var transition = new JIRA.WorkflowDesigner.TransitionModel();
    strictEqual(transition.getSourceStepId(), null, "getSourceStepId() returned undefined");
});

test("getTargetStepId() returns null when target isn't set", function () {
    var transition = new JIRA.WorkflowDesigner.TransitionModel();
    strictEqual(transition.getTargetStepId(), null, "getTargetStepId() returned undefined");
});

test("ID is set when creating initial transition", function () {
    var transition = this.createTransition({initial: true});
    equal(transition.get("id"), "IA<1:source:target>");
});

test("ID is set when creating transition", function () {
    var transition = this.createTransition();
    equal(transition.get("id"), "A<1:source:target>");
});

test("ID is updated when setting action ID, source or target", function () {
    var transition = this.createTransition();

    transition.set("actionId", 2);
    equal(transition.get("id"), "A<2:source:target>");

    transition.set("source", new JIRA.WorkflowDesigner.StatusModel({id: "newSource"}));
    equal(transition.get("id"), "A<2:newSource:target>");

    transition.set("target", new JIRA.WorkflowDesigner.StatusModel({id: "newTarget"}));
    equal(transition.get("id"), "A<2:newSource:newTarget>");
});

test("setTarget updates the target status and the target angle", function () {
    var newTarget = new JIRA.WorkflowDesigner.StatusModel({}),
        transition = this.createTransition();

    transition.set("targetAngle", 90);

    transition.setTarget(newTarget, 0);

    equal(transition.get("target"), newTarget, "Target was set");
    equal(transition.get("targetAngle"), 0, "Target angle was unset");
});

test("setSource updates the source status and the source angle", function () {
    var newSource = new JIRA.WorkflowDesigner.StatusModel({}),
        transition = this.createTransition();

    transition.set("sourceAngle", 90);

    transition.setSource(newSource, 0);

    equal(transition.get("source"), newSource, "Source was set");
    equal(transition.get("sourceAngle"), 0, "Source angle was unset");
});