AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.StatusModel");

test("hasCoordinates()", function () {
    var statusModel;

    statusModel = new JIRA.WorkflowDesigner.StatusModel();
    ok(!statusModel.hasCoordinates(), "With neither x nor y set, hasCoordinates() returns false");

    statusModel.set({x: 0});
    ok(!statusModel.hasCoordinates(), "With only x set, hasCoordinates() returns false");

    statusModel.set({x: null, y: 0});
    ok(!statusModel.hasCoordinates(), "With only y set, hasCoordinates() returns false");

    statusModel.set({x: 0, y: 0});
    ok(statusModel.hasCoordinates(), "With both x and y set, hasCoordinates() returns true");
});

test("hasTransition()", function () {
    var transitionModel = new JIRA.WorkflowDesigner.TransitionModel(),
        statusModel = new JIRA.WorkflowDesigner.StatusModel();

    ok(!statusModel.hasTransition(transitionModel), "The status is not related to the transition");

    transitionModel.set("source", statusModel);
    ok(statusModel.hasTransition(transitionModel), "The status is the source of the transition");

    transitionModel.unset("source");
    transitionModel.set("target", statusModel);
    ok(statusModel.hasTransition(transitionModel), "The status is the target of the transition");
});