(function () {
    AJS.namespace("JIRA.WorkflowDesigner.Layout.Locator.StaticLocator");

    JIRA.WorkflowDesigner.Layout.Locator.StaticLocator = draw2d.layout.locator.Locator.extend(
    /** @lends JIRA.WorkflowDesigner.Layout.Locator.StaticLocator# */
    {
        /**
         * Initialise the locator.
         *
         * @classdesc A Draw2D locator that positions a figure at a fixed location.
         * @constructs
         * @extends draw2d.layout.locator.Locator
         * @param {draw2d.Figure} parent The parent figure.
         * @param {number} x The child figure's x position.
         * @param {number} y The child figure's y position.
         */
        init: function (parent, x, y) {
            this._super(parent);

            this._x = x;
            this._y = y;
        },

        /**
         * Relocate a child figure.
         *
         * @param {number} index The child figure's index.
         * @param {draw2d.Figure} target The child figure.
         */
        relocate: function (index, target) {
            target.setPosition(this._x, this._y);
        }
    });
}());