AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Layout.Locator.PositionOnParentBoundsLocator", {
    assertRelocation: function(side, bias, expectedX, expectedY) {
        var locator,
            parentBoundingBox = new draw2d.geo.Rectangle(0, 0, 100, 100),
            target = {setPosition: sinon.spy()};

        locator = new JIRA.WorkflowDesigner.Layout.Locator.PositionOnParentBoundsLocator({
            parent: {getBoundingBox: function () { return parentBoundingBox; }},
            side: side,
            bias: bias
        });

        locator.relocate(0, target);
        equal(target.setPosition.callCount, 1, "The target's setPosition() method was called");
        ok(target.setPosition.calledWithExactly(expectedX, expectedY), "It was passed the correct x and y coordinates");
    }
});

test("relocate()", function () {
    this.assertRelocation(JIRA.WorkflowDesigner.Direction.UP, 0.5, 50, 0);
    this.assertRelocation(JIRA.WorkflowDesigner.Direction.DOWN, 0.5, 50, 100);
    this.assertRelocation(JIRA.WorkflowDesigner.Direction.LEFT, 0.5, 0, 50);
    this.assertRelocation(JIRA.WorkflowDesigner.Direction.RIGHT, 0.5, 100, 50);
});