AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager",{setup:function(){this.sandbox=sinon.sandbox.create({useFakeServer:true})},teardown:function(){this.sandbox.restore()}});test("Successfully loading a workflow",function(){var B=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.load("Workflow"),A;A={layout:simpleLayoutJSON,liveStepIds:[1,2]};this.sandbox.server.respondWith(JSON.stringify(A));this.sandbox.server.respond();equal(B.state(),"resolved","The returned deferred is resolved on success");B.done(function(D,C){equal(arguments.length,2,"The deferred was resolved with two arguments");ok(D.updatedDate.getTime()===100000,"The correct last updated date was loaded");deepEqual(D.updateAuthor,{userName:"bob",displayName:"Bob Dude"},"The correct last updater details were loaded");deepEqual(D.liveStepIds,[1,2],"The correct live step ID-s were loaded");equal(D.statuses.length,6,"The correct number of statuses were loaded");equal(D.transitions.length,4,"The correct number of transitions were loaded");deepEqual(C,A,"The JSON response was passed to the done handler")})});test("Unsuccessfully loading a workflow because server rejected request.",function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.load("workflow");this.sandbox.server.respond();equal(A.state(),"rejected","The returned deferred is rejected on failure")});test("Successfully saving a workflow",function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.save(new JIRA.WorkflowDesigner.WorkflowModel());this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows","");this.sandbox.server.respond();equal(A.state(),"resolved","The returned deferred is resolved on success")});test("Unsuccessfully saving a workflow because server rejected request.",function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.save(new JIRA.WorkflowDesigner.WorkflowModel());this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows",[400,{},"Page not found"]);this.sandbox.server.respond();equal(A.state(),"rejected","The returned deferred is rejected on failure");A.fail(function(B){equal(B,"Page not found","Callback received the right response")})});test("Call to save a workflow was rejected because a draft was already being published or discarded.",function(){var B,A=new JIRA.WorkflowDesigner.WorkflowModel();JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.publish(A);this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/publishDraft","");B=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.save(A);this.sandbox.server.respond();equal(B.state(),"pending","The save promise is pending when a draft was already being published or discarded.");equal(this.sandbox.server.requests.length,1,"Only the publish request was made");equal(this.sandbox.server.requests[0].url,AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/publishDraft","The only request is to publish")});test("A successful workflow publish returns a resolved promise",1,function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.publish(new JIRA.WorkflowDesigner.WorkflowModel());this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/publishDraft","");this.sandbox.server.respond();equal(A.state(),"resolved","The returned deferred is resolved on success")});test("Unsuccessfully publishing a workflow because server rejected request.",2,function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.publish(new JIRA.WorkflowDesigner.WorkflowModel());this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/publishDraft",[400,{},"Bad request"]);this.sandbox.server.respond();equal(A.state(),"rejected","The returned promise is rejected on failure");A.fail(function(B){equal(B,"Bad request","Callback received the right response")})});test("A successful workflow discard returns a resolved promise",1,function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.discard("workflow");this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/discardDraft","");this.sandbox.server.respond();equal(A.state(),"resolved","The returned deferred is resolved on success")});test("Unsuccessfully discarding a workflow because server rejected request.",2,function(){var A=JIRA.WorkflowDesigner.IO.AJAX.WorkflowAJAXManager.discard("Workflow");this.sandbox.server.respondWith(AJS.contextPath()+"/rest/workflowDesigner/latest/workflows/discardDraft",[400,{},"Bad request"]);this.sandbox.server.respond();equal(A.state(),"rejected","The returned deferred is rejected on failure");A.fail(function(B){equal(B,"Bad request","Callback received the right response")})});