(function (Backbone) {
    /**
     * A collection of {@link JIRA.WorkflowDesigner.StatusModel}s.
     *
     * @class JIRA.WorkflowDesigner.StatusCollection
     * @extends Backbone.Collection
     */
    Backbone.define("JIRA.WorkflowDesigner.StatusCollection", Backbone.Collection.extend(
    /** @lends JIRA.WorkflowDesigner.StatusCollection# */
    {
        /**
         * The model class that the collection contains
         *
         * @param {object} attributes
         * @param {object} options
         * @returns {JIRA.WorkflowDesigner.StatusModel}
         */
        model: function (attributes, options) {
            return new JIRA.WorkflowDesigner.StatusModel(attributes, options);
        }
    }));
}(JIRA.WorkflowDesigner.Backbone));