AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-read-only");module("JIRA.WorkflowDesigner.CanvasModel",{setup:function(){this.sandbox=sinon.sandbox.create();this.workflowModel=new JIRA.WorkflowDesigner.WorkflowModel();this.canvasModel=new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel})},teardown:function(){this.sandbox.restore()}});test("Deselects the selected model/view when it is destroyed",function(){var A=this.workflowModel.addTransition({});this.canvasModel.set({selectedModel:A,selectedView:{}});A.destroy();ok(!this.canvasModel.has("selectedModel"),"The selectedModel property is cleared");ok(!this.canvasModel.has("selectedView"),"The selectedView property is cleared")});test("selectView()",function(){var A={model:{}};this.canvasModel.selectView(A);ok(this.canvasModel.get("selectedModel")===A.model,"The WorkflowModel's selectedModel property was set");ok(this.canvasModel.get("selectedView")===A,"The WorkflowModel's selectedView property was set")});test("Selects new statuses",function(){var A=this.workflowModel.addStatus({name:"Closed"}),B=this.workflowModel.addStatus({name:"Open"});this.workflowModel.trigger("new:status",A);ok(this.canvasModel.get("selectedModel")===A,"The new status was selected");this.workflowModel.trigger("new:status",B);ok(this.canvasModel.get("selectedModel")===A,"The new status wasn't selected")});test("Selects new transitions",function(){var B=this.workflowModel.addTransition({name:"Close"}),A=this.workflowModel.addTransition({name:"Open"});this.workflowModel.trigger("new:transition",B);ok(this.canvasModel.get("selectedModel")===B,"The new transition was selected");this.workflowModel.trigger("new:transition",A);ok(this.canvasModel.get("selectedModel")===B,"The new transition wasn't selected")});test('Setting the "showTransitionLabels" property triggers an analytics event',function(){this.sandbox.stub(JIRA.WorkflowDesigner.Analytics,"triggerToggleLabels");this.canvasModel.set("showTransitionLabels",false);JIRA.WorkflowDesigner.Analytics.triggerToggleLabels.reset();this.canvasModel.set("showTransitionLabels",true);equal(JIRA.WorkflowDesigner.Analytics.triggerToggleLabels.args[0][0],true,"An analytics event is triggered when labels are shown");this.canvasModel.set("showTransitionLabels",false);equal(JIRA.WorkflowDesigner.Analytics.triggerToggleLabels.args[1][0],false,"An analytics event is triggered when labels are hidden")});test('The user\'s "show transition labels" preference defaults to false',function(){var A;A=new JIRA.WorkflowDesigner.CanvasModel({},{workflowModel:this.workflowModel});strictEqual(A.get("showTransitionLabels"),false,"The showTransitionLabels property has defaulted to false")});