AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");
AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");

module("JIRA.WorkflowDesigner.Canvas", {
    setup: function () {
        this.sandbox = sinon.sandbox.create();
        this.sandbox.spy(JIRA.WorkflowDesigner, "ActionsView");
        this.sandbox.spy(JIRA.WorkflowDesigner, "ZoomControlView");
        this.sandbox.spy(JIRA.WorkflowDesigner.Canvas.prototype, "hideProgressIndicator");
        this.sandbox.spy(JIRA.WorkflowDesigner.Canvas.prototype, "showProgressIndicator");
        this.sandbox.spy(JIRA.WorkflowDesigner.PropertiesPanel, "PropertiesPanelView");
    },

    teardown: function () {
        this.sandbox.restore();
    }
});

test("autoFit()", function () {
    var autoFitSpy = this.sandbox.spy(JIRA.WorkflowDesigner.CanvasView.prototype, "autoFit"),
        canvas = JIRA.WorkflowDesigner.TestUtilities.testCanvas();

    canvas.autoFit();
    equal(autoFitSpy.callCount, 1, "CanvasView#autoFit was called");
});

test("Creates an ActionsView when necessary", function () {
    JIRA.WorkflowDesigner.TestUtilities.testCanvas();
    equal(JIRA.WorkflowDesigner.ActionsView.callCount, 1, "An ActionsView was created");

    JIRA.WorkflowDesigner.TestUtilities.testCanvas({actions: false});
    equal(JIRA.WorkflowDesigner.ActionsView.callCount, 1, "No ActionsView was created");
});

test("Creates a PropertiesPanelView when necessary", function () {
    JIRA.WorkflowDesigner.TestUtilities.testCanvas();
    equal(JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.callCount, 1,
            "A PropertiesPanelView was created");

    JIRA.WorkflowDesigner.TestUtilities.testCanvas({immutable: true});
    equal(JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.callCount, 1,
            "No PropertiesPanelView was created");
});

test("Creates a ZoomControlView", function () {
    var element = jQuery("<div>").appendTo("#qunit-fixture"),
        renderSpy = this.sandbox.spy(JIRA.WorkflowDesigner.ZoomControlView.prototype, "render"),
        zoomControlView;

    JIRA.WorkflowDesigner.TestUtilities.testCanvas({el: element});
    zoomControlView = JIRA.WorkflowDesigner.ZoomControlView.thisValues[0];

    ok(zoomControlView, "A ZoomControlView was created");
    equal(renderSpy.callCount, 1, "Its render method was called");
    ok(jQuery.contains(element[0], zoomControlView.el), "Its element was appended to the workflow designer container");
});

test("Entering and exiting full screen", function () {
    var actionsView,
        container = jQuery("<div>").appendTo("#qunit-fixture"),
        enterFullScreenDeferred = jQuery.Deferred(),
        enterFullScreenStub = this.sandbox.stub(JIRA.WorkflowDesigner.FullScreenController, "enterFullScreen").returns(enterFullScreenDeferred.promise()),
        exitFullScreenDeferred = jQuery.Deferred(),
        exitFullScreenStub = this.sandbox.stub(JIRA.WorkflowDesigner.FullScreenController, "exitFullScreen").returns(exitFullScreenDeferred.promise());

    JIRA.WorkflowDesigner.TestUtilities.testCanvas({el: container});
    actionsView = JIRA.WorkflowDesigner.ActionsView.thisValues[0];

    actionsView.trigger("fullScreen:enter");
    equal(enterFullScreenStub.callCount, 1, "JIRA.WorkflowDesigner.FullScreenController.enterFullScreen() was called");
    ok(enterFullScreenStub.args[0][0] === container[0], "It was passed the correct arguments");

    enterFullScreenDeferred.resolve();

    actionsView.trigger("fullScreen:exit");
    equal(exitFullScreenStub.callCount, 1, "JIRA.WorkflowDesigner.FullScreenController.exitFullScreen() was called");
    ok(exitFullScreenStub.args[0][0] === container[0], "It was passed the correct arguments");

    exitFullScreenDeferred.resolve();
});

test("Hiding and showing a progress indicator", function () {
    var canvas = JIRA.WorkflowDesigner.TestUtilities.testCanvas(),
        hideSpy = this.sandbox.spy(JIRA.WorkflowDesigner.ProgressIndicatorBlanketView.prototype, "hide"),
        progressIndicatorBlanketViewSpy = this.sandbox.spy(JIRA.WorkflowDesigner, "ProgressIndicatorBlanketView"),
        setLockedSpy = this.sandbox.spy(JIRA.WorkflowDesigner.CanvasView.prototype, "setLocked"),
        showSpy = this.sandbox.spy(JIRA.WorkflowDesigner.ProgressIndicatorBlanketView.prototype, "show");

    canvas.showProgressIndicator();
    ok(setLockedSpy.calledWith(true), "The CanvasView was locked");
    equal(progressIndicatorBlanketViewSpy.callCount, 1, "A ProgressIndicatorBlanketView was created");
    ok(progressIndicatorBlanketViewSpy.args[0][0].container === canvas.el, "It was passed the Canvas element");
    equal(showSpy.callCount, 1, "The ProgressIndicatorBlanketView was shown");

    canvas.hideProgressIndicator();
    ok(setLockedSpy.calledWith(false), "The CanvasView was unlocked");
    equal(hideSpy.callCount, 1, "The ProgressIndicatorBlanketView was hidden");
});

test("Shows a progress indicator while adding a status", function () {
    var actionsView, canvas;

    canvas = JIRA.WorkflowDesigner.TestUtilities.testCanvas();
    actionsView = JIRA.WorkflowDesigner.ActionsView.thisValues[0];

    actionsView.trigger("addStatus:submit");
    equal(canvas.showProgressIndicator.callCount, 1, "Canvas#showProgressIndicator was called");

    actionsView.trigger("addStatus:done");
    equal(canvas.hideProgressIndicator.callCount, 1, "Canvas#hideProgressIndicator was called");
});

test("Shows a progress indicator while the properties panel is processing a transaction", function () {
    var canvas, propertiesPanelView;

    canvas = JIRA.WorkflowDesigner.TestUtilities.testCanvas();
    propertiesPanelView = JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.thisValues[0];

    propertiesPanelView.trigger("transaction:start");
    equal(canvas.showProgressIndicator.callCount, 1, "Canvas#showProgressIndicator was called");

    propertiesPanelView.trigger("transaction:end");
    equal(canvas.hideProgressIndicator.callCount, 1, "Canvas#hideProgressIndicator was called");
});

test("Zooms when the ZoomControlView fires zoomIn/Out events", function () {
    var zoomControlView,
        zoomSpy = this.sandbox.stub(JIRA.WorkflowDesigner.CanvasView.prototype, "zoom");

    JIRA.WorkflowDesigner.TestUtilities.testCanvas();
    zoomControlView = JIRA.WorkflowDesigner.ZoomControlView.thisValues[0];

    zoomControlView.trigger("zoomIn");
    equal(zoomSpy.callCount, 1, "CanvasView#zoom was called");
    deepEqual(zoomSpy.args[0], [0.75], "It was passed the correct arguments");

    zoomControlView.trigger("zoomOut");
    equal(zoomSpy.callCount, 2, "CanvasView#zoom was called");
    deepEqual(zoomSpy.args[1], [1.25], "It was passed the correct arguments");
});