AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:test-resources");AJS.test.require("com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer");module("JIRA.WorkflowDesigner.Canvas",{setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.spy(JIRA.WorkflowDesigner,"ActionsView");this.sandbox.spy(JIRA.WorkflowDesigner,"ZoomControlView");this.sandbox.spy(JIRA.WorkflowDesigner.Canvas.prototype,"hideProgressIndicator");this.sandbox.spy(JIRA.WorkflowDesigner.Canvas.prototype,"showProgressIndicator");this.sandbox.spy(JIRA.WorkflowDesigner.PropertiesPanel,"PropertiesPanelView")},teardown:function(){this.sandbox.restore()}});test("autoFit()",function(){var B=this.sandbox.spy(JIRA.WorkflowDesigner.CanvasView.prototype,"autoFit"),A=JIRA.WorkflowDesigner.TestUtilities.testCanvas();A.autoFit();equal(B.callCount,1,"CanvasView#autoFit was called")});test("Creates an ActionsView when necessary",function(){JIRA.WorkflowDesigner.TestUtilities.testCanvas();equal(JIRA.WorkflowDesigner.ActionsView.callCount,1,"An ActionsView was created");JIRA.WorkflowDesigner.TestUtilities.testCanvas({actions:false});equal(JIRA.WorkflowDesigner.ActionsView.callCount,1,"No ActionsView was created")});test("Creates a PropertiesPanelView when necessary",function(){JIRA.WorkflowDesigner.TestUtilities.testCanvas();equal(JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.callCount,1,"A PropertiesPanelView was created");JIRA.WorkflowDesigner.TestUtilities.testCanvas({immutable:true});equal(JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.callCount,1,"No PropertiesPanelView was created")});test("Creates a ZoomControlView",function(){var A=jQuery("<div>").appendTo("#qunit-fixture"),C=this.sandbox.spy(JIRA.WorkflowDesigner.ZoomControlView.prototype,"render"),B;JIRA.WorkflowDesigner.TestUtilities.testCanvas({el:A});B=JIRA.WorkflowDesigner.ZoomControlView.thisValues[0];ok(B,"A ZoomControlView was created");equal(C.callCount,1,"Its render method was called");ok(jQuery.contains(A[0],B.el),"Its element was appended to the workflow designer container")});test("Entering and exiting full screen",function(){var D,C=jQuery("<div>").appendTo("#qunit-fixture"),E=jQuery.Deferred(),F=this.sandbox.stub(JIRA.WorkflowDesigner.FullScreenController,"enterFullScreen").returns(E.promise()),B=jQuery.Deferred(),A=this.sandbox.stub(JIRA.WorkflowDesigner.FullScreenController,"exitFullScreen").returns(B.promise());JIRA.WorkflowDesigner.TestUtilities.testCanvas({el:C});D=JIRA.WorkflowDesigner.ActionsView.thisValues[0];D.trigger("fullScreen:enter");equal(F.callCount,1,"JIRA.WorkflowDesigner.FullScreenController.enterFullScreen() was called");ok(F.args[0][0]===C[0],"It was passed the correct arguments");E.resolve();D.trigger("fullScreen:exit");equal(A.callCount,1,"JIRA.WorkflowDesigner.FullScreenController.exitFullScreen() was called");ok(A.args[0][0]===C[0],"It was passed the correct arguments");B.resolve()});test("Hiding and showing a progress indicator",function(){var A=JIRA.WorkflowDesigner.TestUtilities.testCanvas(),D=this.sandbox.spy(JIRA.WorkflowDesigner.ProgressIndicatorBlanketView.prototype,"hide"),C=this.sandbox.spy(JIRA.WorkflowDesigner,"ProgressIndicatorBlanketView"),E=this.sandbox.spy(JIRA.WorkflowDesigner.CanvasView.prototype,"setLocked"),B=this.sandbox.spy(JIRA.WorkflowDesigner.ProgressIndicatorBlanketView.prototype,"show");A.showProgressIndicator();ok(E.calledWith(true),"The CanvasView was locked");equal(C.callCount,1,"A ProgressIndicatorBlanketView was created");ok(C.args[0][0].container===A.el,"It was passed the Canvas element");equal(B.callCount,1,"The ProgressIndicatorBlanketView was shown");A.hideProgressIndicator();ok(E.calledWith(false),"The CanvasView was unlocked");equal(D.callCount,1,"The ProgressIndicatorBlanketView was hidden")});test("Shows a progress indicator while adding a status",function(){var A,B;B=JIRA.WorkflowDesigner.TestUtilities.testCanvas();A=JIRA.WorkflowDesigner.ActionsView.thisValues[0];A.trigger("addStatus:submit");equal(B.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator was called");A.trigger("addStatus:done");equal(B.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator was called")});test("Shows a progress indicator while the properties panel is processing a transaction",function(){var A,B;A=JIRA.WorkflowDesigner.TestUtilities.testCanvas();B=JIRA.WorkflowDesigner.PropertiesPanel.PropertiesPanelView.thisValues[0];B.trigger("transaction:start");equal(A.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator was called");B.trigger("transaction:end");equal(A.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator was called")});test("Zooms when the ZoomControlView fires zoomIn/Out events",function(){var B,A=this.sandbox.stub(JIRA.WorkflowDesigner.CanvasView.prototype,"zoom");JIRA.WorkflowDesigner.TestUtilities.testCanvas();B=JIRA.WorkflowDesigner.ZoomControlView.thisValues[0];B.trigger("zoomIn");equal(A.callCount,1,"CanvasView#zoom was called");deepEqual(A.args[0],[0.75],"It was passed the correct arguments");B.trigger("zoomOut");equal(A.callCount,2,"CanvasView#zoom was called");deepEqual(A.args[1],[1.25],"It was passed the correct arguments")});