/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.model.layout.serialize;

import com.sysbliss.jira.plugins.workflow.model.layout.AnnotationLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.AnnotationLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JWDSerializableLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.JWDSerializableLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.LayoutDeserializer;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableAnnotation;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableEdge;
import com.sysbliss.jira.plugins.workflow.model.layout.serialize.SerializableNode;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;

public class JSONLayoutDeserializer
implements LayoutDeserializer {
    private JWDSerializableLayout serializedLayout;
    private HashMap<String, NodeLayout> nodeLayoutMap;
    private HashMap<String, EdgeLayout> edgeLayoutMap;

    @Override
    public JWDLayout deserialize(String packet) throws Exception {
        this.edgeLayoutMap = new HashMap();
        this.nodeLayoutMap = new HashMap();
        JWDLayoutImpl layout = new JWDLayoutImpl();
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory jf = new JsonFactory();
        this.serializedLayout = (JWDSerializableLayout)mapper.readValue(jf.createJsonParser((Reader)new StringReader(packet)), JWDSerializableLayoutImpl.class);
        layout.setWidth(this.serializedLayout.getWidth());
        List<String> rootIds = this.serializedLayout.getRootIds();
        int n = rootIds.size();
        ArrayList<NodeLayout> roots = new ArrayList<NodeLayout>(n);
        for (int i = 0; i < n; ++i) {
            String nodeId = rootIds.get(i);
            NodeLayout node = this.deserializeNode(nodeId);
            roots.add(node);
        }
        layout.setRoots(roots);
        ArrayList<AnnotationLayout> annotationLayouts = new ArrayList<AnnotationLayout>();
        for (SerializableAnnotation annotation : this.serializedLayout.getAnnotations()) {
            AnnotationLayout annotationLayout = this.deserializeAnnotation(annotation);
            annotationLayouts.add(annotationLayout);
        }
        layout.setAnnotations(annotationLayouts);
        this.serializedLayout = null;
        this.edgeLayoutMap = null;
        this.nodeLayoutMap = null;
        return layout;
    }

    private AnnotationLayout deserializeAnnotation(SerializableAnnotation annotation) {
        AnnotationLayoutImpl annotationLayout = new AnnotationLayoutImpl();
        annotationLayout.setId(annotation.getId());
        annotationLayout.setRect(annotation.getRect());
        return annotationLayout;
    }

    private NodeLayout deserializeNode(String nodeId) {
        if (this.nodeLayoutMap.containsKey(nodeId)) {
            NodeLayout nodeLayout = this.nodeLayoutMap.get(nodeId);
            return nodeLayout;
        }
        SerializableNode node = this.serializedLayout.getNodeMap().get(nodeId);
        NodeLayoutImpl nodeLayout = new NodeLayoutImpl();
        nodeLayout.setId(node.getId());
        nodeLayout.setLabel(node.getLabel());
        this.nodeLayoutMap.put(nodeId, nodeLayout);
        nodeLayout.setStepId(node.getStepId());
        nodeLayout.setIsInitialAction(node.getIsInitialAction());
        nodeLayout.setRect(node.getRect());
        ArrayList<EdgeLayout> inLinks = new ArrayList<EdgeLayout>(node.getInLinkIds().size());
        ArrayList<EdgeLayout> outLinks = new ArrayList<EdgeLayout>(node.getOutLinkIds().size());
        for (String edgeId : node.getInLinkIds()) {
            EdgeLayout edgeLayout = this.deserializeEdge(edgeId);
            inLinks.add(edgeLayout);
        }
        nodeLayout.setInLinks(inLinks);
        for (String edgeId : node.getOutLinkIds()) {
            EdgeLayout edgeLayout = this.deserializeEdge(edgeId);
            outLinks.add(edgeLayout);
        }
        nodeLayout.setOutLinks(outLinks);
        return nodeLayout;
    }

    private EdgeLayout deserializeEdge(String edgeId) {
        if (this.edgeLayoutMap.containsKey(edgeId)) {
            EdgeLayout edgeLayout = this.edgeLayoutMap.get(edgeId);
            return edgeLayout;
        }
        SerializableEdge edge = this.serializedLayout.getEdgeMap().get(edgeId);
        EdgeLayoutImpl edgeLayout = new EdgeLayoutImpl();
        edgeLayout.setId(edge.getId());
        edgeLayout.setLabel(edge.getLabel());
        this.edgeLayoutMap.put(edgeId, edgeLayout);
        edgeLayout.setActionId(edge.getActionId());
        edgeLayout.setStartStepId(edge.getStartStepId());
        edgeLayout.setEndStepId(edge.getEndStepId());
        edgeLayout.setStartPoint(edge.getStartPoint());
        edgeLayout.setEndPoint(edge.getEndPoint());
        edgeLayout.setControlPoints(edge.getControlPoints());
        edgeLayout.setLineType(edge.getLineType());
        edgeLayout.setLabelPoint(edge.getLabelPoint());
        NodeLayout startNode = this.deserializeNode(edge.getStartNodeId());
        edgeLayout.setStartNode(startNode);
        NodeLayout endNode = this.deserializeNode(edge.getEndNodeId());
        edgeLayout.setEndNode(endNode);
        return edgeLayout;
    }
}

