/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.jgraph;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.sysbliss.jira.plugins.workflow.jgraph.JWDLayoutVisitor;
import com.sysbliss.jira.plugins.workflow.jgraph.JWDLayoutWalker;
import com.sysbliss.jira.plugins.workflow.model.layout.AnnotationLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.AnnotationLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.EdgeLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.JWDLayoutImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutPoint;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutPointImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutRect;
import com.sysbliss.jira.plugins.workflow.model.layout.LayoutRectImpl;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayout;
import com.sysbliss.jira.plugins.workflow.model.layout.NodeLayoutImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;

public class JWDLayoutMerger {
    private static final Logger log = Logger.getLogger(JWDLayoutMerger.class);

    public static JWDLayout mergeLayouts(JWDLayout saved, JWDLayout calculated) {
        JWDLayoutImpl newLayout = new JWDLayoutImpl();
        newLayout.setIsDraftWorkflow(saved.getIsDraftWorkflow());
        newLayout.setGraphBounds(JWDLayoutMerger.clone(saved.getGraphBounds()));
        newLayout.setWidth(saved.getWidth());
        newLayout.setWorkflowName(saved.getWorkflowName());
        newLayout.setAnnotations(JWDLayoutMerger.clone(saved.getAnnotations(), new Function<AnnotationLayout, AnnotationLayout>(){

            public AnnotationLayout apply(@Nullable AnnotationLayout input) {
                return JWDLayoutMerger.clone(input);
            }
        }));
        JWDIndexedLayout savedIndexed = new JWDIndexedLayout(saved);
        JWDIndexedLayout calculatedIndexed = new JWDIndexedLayout(calculated);
        JWDIndexedLayout newIndexed = new JWDIndexedLayout(newLayout);
        JWDLayoutMerger.mergeNodes(newIndexed, savedIndexed, calculatedIndexed);
        JWDLayoutMerger.mergeEdges(newIndexed, savedIndexed, calculatedIndexed);
        return newIndexed.layout;
    }

    private JWDLayoutMerger() {
    }

    private static AnnotationLayout clone(AnnotationLayout layout) {
        if (layout == null) {
            return null;
        }
        AnnotationLayoutImpl clone = new AnnotationLayoutImpl();
        clone.setId(layout.getId());
        clone.setLabel(layout.getLabel());
        clone.setRect(JWDLayoutMerger.clone(layout.getRect()));
        return clone;
    }

    private static LayoutRect clone(LayoutRect rect) {
        return rect != null ? new LayoutRectImpl(rect) : null;
    }

    private static LayoutPoint clone(LayoutPoint point) {
        return point != null ? new LayoutPointImpl(point) : null;
    }

    private static <T> List<T> clone(Iterable<T> iterable, Function<T, T> cloneFunction) {
        if (iterable == null) {
            return null;
        }
        return Lists.newArrayList((Iterable)Iterables.transform(iterable, cloneFunction));
    }

    private static NodeLayout shallowClone(NodeLayout nodeLayout) {
        NodeLayoutImpl copy = new NodeLayoutImpl();
        copy.setStepId(nodeLayout.getStepId());
        copy.setIsInitialAction(nodeLayout.getIsInitialAction());
        copy.setId(nodeLayout.getId());
        copy.setLabel(nodeLayout.getLabel());
        return copy;
    }

    private static NodeLayout clone(NodeLayout nodeLayout) {
        NodeLayout copy = JWDLayoutMerger.shallowClone(nodeLayout);
        copy.setRect(JWDLayoutMerger.clone(nodeLayout.getRect()));
        return copy;
    }

    private static EdgeLayout cloneAndLink(EdgeLayout edge, NodeLayout startNode, NodeLayout endNode) {
        EdgeLayoutImpl cloned = new EdgeLayoutImpl();
        cloned.setId(edge.getId());
        cloned.setLabel(edge.getLabel());
        cloned.setLineType(edge.getLineType());
        cloned.setStartStepId(edge.getStartStepId());
        cloned.setEndStepId(edge.getEndStepId());
        cloned.setActionId(edge.getActionId());
        cloned.setStartNode(startNode);
        cloned.setEndNode(endNode);
        cloned.setLabelPoint(JWDLayoutMerger.clone(edge.getLabelPoint()));
        cloned.setControlPoints(JWDLayoutMerger.clone(edge.getControlPoints(), new Function<LayoutPoint, LayoutPoint>(){

            public LayoutPoint apply(@Nullable LayoutPoint input) {
                return JWDLayoutMerger.clone(input);
            }
        }));
        cloned.setStartPoint(JWDLayoutMerger.movePointInsideOfRectOrClone(startNode.getRect(), edge.getStartPoint()));
        cloned.setEndPoint(JWDLayoutMerger.movePointInsideOfRectOrClone(endNode.getRect(), edge.getEndPoint()));
        startNode.getOutLinks().add(cloned);
        endNode.getInLinks().add(cloned);
        return cloned;
    }

    private static LayoutPoint movePointInsideOfRectOrClone(LayoutRect rect, LayoutPoint point) {
        if (point == null || !JWDLayoutMerger.pointInsideRect(point, rect)) {
            point = new LayoutPointImpl();
            point.setX(rect.getX() + rect.getWidth() / 2.0);
            point.setY(rect.getY() + rect.getHeight() / 2.0);
            return point;
        }
        return JWDLayoutMerger.clone(point);
    }

    private static boolean pointInsideRect(LayoutPoint point, LayoutRect rect) {
        double w = rect.getWidth();
        double h = rect.getHeight();
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        double x = rect.getX();
        double y = rect.getY();
        if (point.getX() < x || point.getY() < y) {
            return false;
        }
        return ((w += x) < x || w > point.getX()) && ((h += y) < y || h > point.getY());
    }

    private static double safeUnbox(Double d) {
        return d == null ? Double.MIN_VALUE : d;
    }

    private static boolean isValid(LayoutRect rect) {
        return rect != null && JWDLayoutMerger.safeUnbox(rect.getX()) >= 0.0 && JWDLayoutMerger.safeUnbox(rect.getY()) >= 0.0 && JWDLayoutMerger.safeUnbox(rect.getWidth()) > 0.0 && JWDLayoutMerger.safeUnbox(rect.getHeight()) > 0.0;
    }

    private static NodeLayout mergeNode(NodeLayout savedNode, NodeLayout calculatedNode) {
        NodeLayout nodeLayout = JWDLayoutMerger.shallowClone(savedNode);
        LayoutRect rect = savedNode.getRect();
        if (!JWDLayoutMerger.isValid(rect)) {
            rect = calculatedNode.getRect();
        }
        LayoutRect newRect = JWDLayoutMerger.clone(rect);
        if (!nodeLayout.getLabel().equals(calculatedNode.getLabel())) {
            LayoutRect calRect = calculatedNode.getRect();
            double diff = calRect.getWidth() - newRect.getWidth();
            if (Math.abs(diff) > 1.0) {
                newRect.setWidth(calRect.getWidth());
                newRect.setX(Math.max(0.0, newRect.getX() - diff / 2.0));
            }
            nodeLayout.setLabel(calculatedNode.getLabel());
        }
        nodeLayout.setRect(newRect);
        return nodeLayout;
    }

    private static EdgeLayout mergeEdge(JWDIndexedLayout layout, EdgeLayout savedEdge, EdgeLayout calculatedEdge) {
        NodeKey endKey = new NodeKey(savedEdge.getEndNode());
        NodeKey startKey = new NodeKey(savedEdge.getStartNode());
        NodeLayout endLayout = (NodeLayout)layout.nodes.get(endKey);
        NodeLayout startLayout = (NodeLayout)layout.nodes.get(startKey);
        if (endLayout == null || startLayout == null) {
            return null;
        }
        EdgeLayout result = JWDLayoutMerger.cloneAndLink(savedEdge, startLayout, endLayout);
        if (calculatedEdge != null) {
            result.setLabel(calculatedEdge.getLabel());
        }
        return result;
    }

    private static void mergeNodes(JWDIndexedLayout layout, JWDIndexedLayout saved, JWDIndexedLayout calculated) {
        for (Map.Entry entry : saved.nodes.entrySet()) {
            NodeLayout savedNode = (NodeLayout)entry.getValue();
            NodeKey nodeKey = (NodeKey)entry.getKey();
            NodeLayout newNode = (NodeLayout)calculated.nodes.get(nodeKey);
            if (newNode == null) continue;
            layout.addNode(JWDLayoutMerger.mergeNode(savedNode, newNode), calculated.roots.contains(nodeKey));
        }
        for (NodeKey nodeKey : Sets.difference(calculated.nodes.keySet(), saved.nodes.keySet())) {
            layout.addNode(JWDLayoutMerger.clone((NodeLayout)calculated.nodes.get(nodeKey)), calculated.roots.contains(nodeKey));
        }
    }

    private static void mergeEdges(JWDIndexedLayout layout, JWDIndexedLayout saved, JWDIndexedLayout calculated) {
        for (Map.Entry entry : saved.edges.asMap().entrySet()) {
            Collection savedEdges = (Collection)entry.getValue();
            Iterator edgeLayoutIterator = calculated.edges.get(entry.getKey()).iterator();
            if (!edgeLayoutIterator.hasNext()) continue;
            EdgeLayout newEdge = (EdgeLayout)edgeLayoutIterator.next();
            if (edgeLayoutIterator.hasNext()) {
                newEdge = null;
            }
            for (EdgeLayout savedEdge : savedEdges) {
                JWDLayoutMerger.mergeEdge(layout, savedEdge, newEdge);
            }
        }
        for (EdgeKey edge : Sets.difference((Set)calculated.edges.keySet(), (Set)saved.edges.keySet())) {
            Collection edgeLayouts = calculated.edges.get((Object)edge);
            for (EdgeLayout edgeLayout : edgeLayouts) {
                JWDLayoutMerger.mergeEdge(layout, edgeLayout, null);
            }
        }
    }

    private static class EdgeKey {
        private final int hashCode;
        private final int actionId;
        private final NodeKey startKey;
        private final NodeKey endKey;

        private EdgeKey(EdgeLayout edge) {
            this.actionId = edge.getActionId();
            this.startKey = new NodeKey(edge.getStartNode());
            this.endKey = new NodeKey(edge.getEndNode());
            this.hashCode = new HashCodeBuilder().append((Object)edge.getActionId()).append((Object)this.startKey).append((Object)this.endKey).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EdgeKey otherKey = (EdgeKey)o;
            return new EqualsBuilder().append(this.actionId, otherKey.actionId).append((Object)this.startKey, (Object)otherKey.startKey).append((Object)this.endKey, (Object)otherKey.endKey).isEquals();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.format("Edge[%d,%s->%s]", this.actionId, this.startKey, this.endKey);
        }
    }

    private static class NodeKey {
        private final int hashCode;
        private final boolean isInitialAction;
        private final int stepId;

        private NodeKey(NodeLayout node) {
            this.isInitialAction = node.getIsInitialAction();
            this.stepId = node.getStepId();
            this.hashCode = new HashCodeBuilder().append(this.isInitialAction).append(this.stepId).toHashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeKey otherKey = (NodeKey)o;
            return new EqualsBuilder().append(this.isInitialAction, otherKey.isInitialAction).append(this.stepId, otherKey.stepId).isEquals();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return String.format("%s[%d]", this.isInitialAction ? "Initial" : "Step", this.stepId);
        }
    }

    private static class Indexer
    implements JWDLayoutVisitor {
        private final Map<NodeKey, NodeLayout> nodes = Maps.newHashMap();
        private final Multimap<EdgeKey, EdgeLayout> edges = LinkedListMultimap.create();
        private final Set<NodeKey> roots = Sets.newHashSet();

        private Indexer() {
        }

        @Override
        public boolean visitLayout(JWDLayout layout) {
            return true;
        }

        @Override
        public boolean visitRoot(NodeLayout rootLayout) {
            this.roots.add(new NodeKey(rootLayout));
            return this.visitNode(rootLayout);
        }

        @Override
        public boolean visitNode(NodeLayout nodeLayout) {
            NodeKey key = new NodeKey(nodeLayout);
            if (this.nodes.containsKey(key)) {
                log.debug((Object)"Layout has more than one step with the same id.");
            } else {
                this.nodes.put(key, nodeLayout);
            }
            return true;
        }

        @Override
        public boolean visitEdge(EdgeLayout edgeLayout) {
            EdgeKey key = new EdgeKey(edgeLayout);
            if (this.edges.containsKey((Object)key)) {
                log.debug((Object)"Layout has duplicate actions.");
            } else {
                this.edges.put((Object)key, (Object)edgeLayout);
            }
            return true;
        }
    }

    private static class JWDIndexedLayout {
        private final Map<NodeKey, NodeLayout> nodes;
        private final Multimap<EdgeKey, EdgeLayout> edges;
        private final Set<NodeKey> roots;
        private final JWDLayout layout;

        private JWDIndexedLayout(JWDLayout layout) {
            this.layout = layout;
            Indexer visitor = new Indexer();
            JWDLayoutWalker.walk(visitor, layout);
            this.nodes = visitor.nodes;
            this.edges = visitor.edges;
            this.roots = visitor.roots;
        }

        private void addNode(NodeLayout nodeLayout, boolean isRoot) {
            NodeKey key = new NodeKey(nodeLayout);
            this.nodes.put(key, nodeLayout);
            if (isRoot) {
                this.roots.add(key);
                this.layout.getRoots().add(nodeLayout);
            }
        }
    }
}

