/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.util.lang.Pair;
import org.apache.commons.lang3.StringUtils;

public class WorkflowTransitions {
    private final Workflows workflows;
    private final FieldScreenManager fieldScreenManager;
    private final StatusManager statusManager;

    public WorkflowTransitions(Workflows workflows, FieldScreenManager fieldScreenManager, StatusManager statusManager) {
        this.workflows = workflows;
        this.statusManager = statusManager;
        this.fieldScreenManager = fieldScreenManager;
    }

    public ServiceOutcome<TransitionData> addTransitionToWorkflow(String name, String description, Long screenId, int sourceStepId, int targetStepId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyTransitionCanBeAdded(name, workflowName, sourceStepId, targetStepId, screenId);
        if (!verificationResult.isValid()) {
            return Outcomes.errorOutcome(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<TransitionData> transitionAdded = workflow.addTransition(name, description, this.fieldScreenManager.getFieldScreen(screenId), sourceStepId, targetStepId);
        if (transitionAdded.isValid()) {
            this.workflows.saveWorkflow(workflow);
        }
        return transitionAdded;
    }

    public ServiceOutcome<Workflow> updateTransition(int transitionId, String name, String description, Long screenId, int sourceStepId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyTransitionCanBeUpdated(transitionId, name, sourceStepId, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> deleteTransition(int transitionId, int sourceStepId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteTransition(transitionId, sourceStepId);
        if (!result.isValid()) {
            return Outcomes.errorOutcome(result.getErrorCollection());
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> updateTransitionTarget(int transitionId, String targetStatusId, String workflowName) {
        Status status;
        ServiceOutcome<Pair<Workflow, Status>> verificationResult = this.verifyTransitionTargetCanBeUpdated(transitionId, targetStatusId, workflowName);
        if (!verificationResult.isValid()) {
            return Outcomes.errorOutcome(verificationResult);
        }
        Pair result = (Pair)verificationResult.getReturnedValue();
        Workflow workflow = (Workflow)result.first();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateTransitionTarget(transitionId, status = (Status)result.second());
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> updateTransitionSource(int transitionId, String newSourceStatusId, String originalSourceStatusId, String workflowName) {
        ServiceOutcome<TransitionSourceUpdateData> verificationResult = this.verifyTransitionSourceCanBeUpdated(transitionId, newSourceStatusId, originalSourceStatusId, workflowName);
        if (!verificationResult.isValid()) {
            return Outcomes.errorOutcome(verificationResult);
        }
        TransitionSourceUpdateData result = (TransitionSourceUpdateData)verificationResult.getReturnedValue();
        Workflow workflow = result.getWorkflow();
        Status originalSourceStatus = result.getOriginalSourceStatus();
        Status newSourceStatus = result.getNewSourceStatus();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateTransitionSource(transitionId, newSourceStatus, originalSourceStatus);
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> addCommonTransition(String sourceStatusId, int transitionId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyCommonTransitionCanBeUsed(transitionId, sourceStatusId, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> commonTransitionAdded = workflow.addCommonTransition(sourceStatusId, transitionId);
        if (!commonTransitionAdded.isValid()) {
            return commonTransitionAdded;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    private ServiceOutcome<Workflow> verifyCommonTransitionCanBeUsed(int commonTransitionId, String sourceStatusId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        Status status = this.statusManager.getStatus(sourceStatusId);
        if (status == null || !workflow.stepExists(status)) {
            return Outcomes.errorOutcome("workflow.designer.selected.source.status.not.found", new Object[0]);
        }
        if (!workflow.hasTransition(commonTransitionId)) {
            return Outcomes.errorOutcome("workflow.designer.common.transition.not.found", new Object[0]);
        }
        ServiceOutcome<Boolean> statusHasOutgoingTransitionOutcome = workflow.statusHasOutgoingTransition(status, commonTransitionId);
        if (!statusHasOutgoingTransitionOutcome.isValid()) {
            return Outcomes.errorOutcome(statusHasOutgoingTransitionOutcome.getErrorCollection());
        }
        if (((Boolean)statusHasOutgoingTransitionOutcome.getReturnedValue()).booleanValue()) {
            return Outcomes.errorOutcome("workflow.designer.duplicate.common.transition", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> verifyTransitionCanBeAdded(String name, String workflowName, int sourceStepId, int targetStepId, Long screenId) {
        FieldScreen fieldScreen;
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.stepExists(sourceStepId)) {
            return Outcomes.errorOutcome("workflow.designer.selected.source.status.not.found", new Object[0]);
        }
        if (!workflow.stepExists(targetStepId)) {
            return Outcomes.errorOutcome("workflow.designer.selected.target.status.not.found", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> verifyTransitionCanBeUpdated(int transitionId, String name, int sourceStepId, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return Outcomes.errorOutcome("workflow.designer.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && workflow.isDuplicateTransitionName(name, sourceStepId)) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Pair<Workflow, Status>> verifyTransitionTargetCanBeUpdated(int transitionId, String targetStatusId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome);
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return Outcomes.errorOutcome("workflow.designer.updating.transition.not.found", new Object[0]);
        }
        Status status = this.statusManager.getStatus(targetStatusId);
        if (status == null || !workflow.stepExists(status)) {
            return Outcomes.errorOutcome("workflow.designer.selected.target.status.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(Pair.of((Object)workflow, (Object)status));
    }

    private ServiceOutcome<TransitionSourceUpdateData> verifyTransitionSourceCanBeUpdated(int transitionId, String newSourceStatusId, String originalSourceStatusId, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome);
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return Outcomes.errorOutcome("workflow.designer.updating.transition.not.found", new Object[0]);
        }
        Status originalSourceStatus = this.statusManager.getStatus(originalSourceStatusId);
        if (originalSourceStatus == null || !workflow.stepExists(originalSourceStatus)) {
            return Outcomes.errorOutcome("workflow.designer.selected.source.status.not.found", new Object[0]);
        }
        Status newSourceStatus = this.statusManager.getStatus(newSourceStatusId);
        if (newSourceStatus == null || !workflow.stepExists(newSourceStatus)) {
            return Outcomes.errorOutcome("workflow.designer.selected.new.source.status.not.found", new Object[0]);
        }
        if (workflow.commonTransitionExistsFromSource(transitionId, newSourceStatus)) {
            return Outcomes.errorOutcome("workflow.designer.common.transition.exists", new Object[0]);
        }
        return Outcomes.okOutcome(new TransitionSourceUpdateData(workflow, newSourceStatus, originalSourceStatus));
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }

    private static class TransitionSourceUpdateData {
        private Workflow workflow;
        private Status originalSourceStatus;
        private Status newSourceStatus;

        public TransitionSourceUpdateData(Workflow workflow, Status newSourceStatus, Status originalSourceStatus) {
            this.workflow = workflow;
            this.newSourceStatus = newSourceStatus;
            this.originalSourceStatus = originalSourceStatus;
        }

        private Status getNewSourceStatus() {
            return this.newSourceStatus;
        }

        private Status getOriginalSourceStatus() {
            return this.originalSourceStatus;
        }

        private Workflow getWorkflow() {
            return this.workflow;
        }
    }
}

