/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.config.ConstantsService;
import com.atlassian.jira.bc.config.StatusService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.security.JiraAuthenticationContext;
import org.apache.commons.lang.StringUtils;

public class WorkflowStatuses {
    public static final String DEFAULT_ICON_URL = "/images/icons/statuses/generic.png";
    private final JiraAuthenticationContext authenticationContext;
    private final ConstantsService constantsService;
    private final FeatureManager featureManager;
    private final StatusService statusService;
    private final Workflows workflows;

    public WorkflowStatuses(JiraAuthenticationContext authenticationContext, ConstantsService constantsService, FeatureManager featureManager, StatusService statusService, Workflows workflows) {
        this.authenticationContext = authenticationContext;
        this.constantsService = constantsService;
        this.featureManager = featureManager;
        this.statusService = statusService;
        this.workflows = workflows;
    }

    public ServiceOutcome<Workflow> createAndAddStatusToWorkflow(boolean createGlobalTransition, String description, String name, String statusCategoryId, String workflowName) {
        ServiceOutcome<StatusCategory> statusCategoryOutcome = this.getStatusCategory(statusCategoryId);
        if (!statusCategoryOutcome.isValid()) {
            return ServiceOutcomeImpl.error(statusCategoryOutcome);
        }
        ServiceOutcome createStatusOutcome = this.statusService.createStatus(this.authenticationContext.getUser(), name, description, DEFAULT_ICON_URL, (StatusCategory)statusCategoryOutcome.getReturnedValue());
        if (!createStatusOutcome.isValid()) {
            return ServiceOutcomeImpl.error((ServiceOutcome)createStatusOutcome);
        }
        Status status = (Status)createStatusOutcome.getReturnedValue();
        ServiceOutcome<Workflow> addStatusOutcome = createGlobalTransition ? this.addStatusAndGlobalTransitionToWorkflow(status, workflowName) : this.addStatusToWorkflow(status, workflowName);
        if (!addStatusOutcome.isValid()) {
            ServiceResult removeStatusErrors = this.statusService.removeStatus(this.authenticationContext.getUser(), status);
            if (!removeStatusErrors.isValid()) {
                return Outcomes.errorOutcome(removeStatusErrors.getErrorCollection());
            }
            return Outcomes.errorOutcome(addStatusOutcome);
        }
        return addStatusOutcome;
    }

    public ServiceOutcome<Workflow> addStatusAndGlobalTransitionToWorkflow(Status status, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeAdded(status, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> addStatusOutcome = workflow.addStatus(status);
        if (!addStatusOutcome.isValid()) {
            return addStatusOutcome;
        }
        ServiceOutcome<Workflow> addGlobalTransitionOutcome = workflow.addGlobalTransition(status.getName(), null, status, null);
        if (!addGlobalTransitionOutcome.isValid()) {
            return addGlobalTransitionOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> addStatusToWorkflow(Status status, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeAdded(status, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> addStatusOutcome = workflow.addStatus(status);
        if (!addStatusOutcome.isValid()) {
            return addStatusOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> removeStatus(String statusId, String workflowName) {
        Status status = this.statusService.getStatusById(this.authenticationContext.getUser(), statusId);
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeRemoved(status, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> removeStatusOutcome = workflow.removeStatus(status);
        if (!removeStatusOutcome.isValid()) {
            return removeStatusOutcome;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> updateStatus(String description, String name, String statusCategoryId, String statusId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyStatusCanBeUpdated(name, statusCategoryId, statusId, workflowName);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        ServiceOutcome<StatusCategory> statusCategoryOutcome = this.getStatusCategory(statusCategoryId);
        if (!statusCategoryOutcome.isValid()) {
            return Outcomes.errorOutcome(statusCategoryOutcome);
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateStatusOutcome = workflow.updateStatus(statusId, name);
        if (!updateStatusOutcome.isValid()) {
            return updateStatusOutcome;
        }
        Status status = this.statusService.getStatusById(this.authenticationContext.getUser(), statusId);
        String originalStatusName = status.getName();
        ServiceOutcome editStatusOutcome = this.statusService.editStatus(this.authenticationContext.getUser(), status, name, description, status.getIconUrl(), (StatusCategory)statusCategoryOutcome.getReturnedValue());
        if (!editStatusOutcome.isValid()) {
            ServiceOutcome<Workflow> revertStatusOutcome = workflow.updateStatus(statusId, originalStatusName);
            if (!revertStatusOutcome.isValid()) {
                return Outcomes.errorOutcome(revertStatusOutcome);
            }
            return ServiceOutcomeImpl.error((ServiceOutcome)editStatusOutcome);
        }
        return this.workflows.saveWorkflow(workflow);
    }

    private ServiceOutcome<StatusCategory> getStatusCategory(String id) {
        User user = this.authenticationContext.getLoggedInUser();
        if (id == null) {
            return this.constantsService.getDefaultStatusCategory(user);
        }
        return this.constantsService.getStatusCategoryById(user, id);
    }

    private boolean statusLozengesAreEnabled() {
        return this.featureManager.getDarkFeatures().isFeatureEnabled("jira.issue.status.lozenge");
    }

    private boolean stepExistsOnLiveWorkflow(Status status, String workflowName) {
        Workflow liveWorkflow = this.workflows.getWorkflow(false, workflowName);
        return liveWorkflow.stepExists(status);
    }

    private ServiceOutcome<Workflow> verifyStatusCanBeAdded(Status status, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (workflow.workflowContainsStepWithStatusId(status.getId())) {
            return Outcomes.errorOutcome("workflow.designer.status.exists", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> verifyStatusCanBeRemoved(Status status, String workflowName) {
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (workflow.isDraftWorkflow() && this.stepExistsOnLiveWorkflow(status, workflowName)) {
            return Outcomes.forbiddenOperationOutcome();
        }
        if (!workflow.workflowContainsStepWithStatusId(status.getId())) {
            return Outcomes.errorOutcome("workflow.designer.status.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private ServiceOutcome<Workflow> verifyStatusCanBeUpdated(String name, String statusCategoryId, String statusId, String workflowName) {
        if (StringUtils.isBlank((String)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        if (this.statusLozengesAreEnabled() && StringUtils.isBlank((String)statusCategoryId)) {
            return Outcomes.errorOutcome("workflow.designer.please.select.a.status.category", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.workflowContainsStepWithStatusId(statusId)) {
            return Outcomes.errorOutcome("workflow.designer.status.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }
}

