/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.plugins.workflowdesigner.layout.Layout;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializationException;
import com.atlassian.jira.plugins.workflowdesigner.layout.UpdateAuthor;
import com.atlassian.jira.plugins.workflowdesigner.layout.WorkflowLayouts;
import com.atlassian.jira.plugins.workflowdesigner.utilities.UserProjectWorkflowUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.lang.Pair;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import java.util.Date;
import org.apache.log4j.Logger;

public class WorkflowLayoutsImpl
implements WorkflowLayouts {
    private static final Logger LOG = Logger.getLogger(WorkflowLayoutsImpl.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final WorkflowLayoutManager workflowLayoutManager;
    private final Workflows workflows;
    private final UserProjectWorkflowUtilities userProjectWorkflowUtilities;

    public WorkflowLayoutsImpl(JiraAuthenticationContext jiraAuthenticationContext, UserProjectWorkflowUtilities userProjectWorkflowUtilities, WorkflowLayoutManager workflowLayoutManager, Workflows workflows) {
        this.workflowLayoutManager = workflowLayoutManager;
        this.workflows = workflows;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userProjectWorkflowUtilities = userProjectWorkflowUtilities;
    }

    @Override
    public ServiceOutcome<Void> saveLayout(String workflowName, boolean isDraft, Layout layout) {
        Workflow workflow = this.workflows.getWorkflow(isDraft, workflowName);
        if (workflow == null || !this.currentUserCanEditWorkflow(workflow)) {
            return Outcomes.errorOutcome("workflow.designer.workflow.doesnt.exist", new Object[0]);
        }
        layout.setUpdateAuthor(new UpdateAuthor(this.jiraAuthenticationContext.getUser()));
        layout.setUpdatedDate(new Date());
        try {
            this.workflowLayoutManager.saveNewLayout(workflowName, isDraft, layout);
            return Outcomes.okOutcome(null);
        }
        catch (LayoutSerializationException exception) {
            LOG.error((Object)("Error serializing workflow layout for workflow " + workflowName + ", draft = " + isDraft), (Throwable)exception);
            return Outcomes.errorOutcome("workflow.designer.workflow.saving.serialization.failed", new Object[0]);
        }
    }

    @Override
    public ServiceOutcome<Pair<Boolean, Layout>> getLayout(String workflowName, boolean getOrCreateDraft, boolean preferDraft) {
        boolean isDraftLayout;
        Workflow workflow;
        if (preferDraft && !getOrCreateDraft) {
            workflow = this.workflows.getDraftWorkflow(workflowName);
            boolean bl = isDraftLayout = workflow != null;
            if (!isDraftLayout) {
                workflow = this.workflows.getWorkflow(false, workflowName);
            }
        } else {
            isDraftLayout = getOrCreateDraft;
            workflow = this.workflows.getWorkflow(getOrCreateDraft, workflowName);
        }
        if (workflow == null || !this.currentUserCanViewWorkflow(workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.workflow.doesnt.exist", new Object[0]);
        }
        try {
            return Outcomes.okOutcome(Pair.nicePairOf((Object)isDraftLayout, (Object)this.workflowLayoutManager.getNewLayoutOrCreate(isDraftLayout, workflowName)));
        }
        catch (LayoutSerializationException exception) {
            LOG.error((Object)("Error serializing workflow layout for workflow " + workflowName + ", draft = " + isDraftLayout), (Throwable)exception);
            return Outcomes.errorOutcome("workflow.designer.workflow.loading.serialization.failed", new Object[0]);
        }
    }

    private boolean currentUserCanEditWorkflow(Workflow workflow) {
        return workflow.isEditable() && this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getUser(), workflow.getName());
    }

    private boolean currentUserCanViewWorkflow(String workflowName) {
        return this.userProjectWorkflowUtilities.userCanViewWorkflow(this.jiraAuthenticationContext.getUser(), workflowName);
    }
}

