/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.plugins.workflowdesigner.layout.Transition;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.google.common.base.Objects;

public class Transitions {
    public static boolean differentScreen(TransitionData data, Transition transition) {
        Long newScreenId = data.getScreenId();
        String newScreenName = data.getScreenName();
        return !Objects.equal((Object)transition.getScreenId(), (Object)newScreenId) || !Objects.equal((Object)transition.getScreenName(), (Object)newScreenName);
    }

    public static void copyScreenDataToTransition(TransitionData data, Transition transition) {
        transition.setScreenId(data.getScreenId());
        transition.setScreenName(data.getScreenName());
    }

    public static Transition create(TransitionData data, String sourceId, String targetId) {
        Transition transition = new Transition(data.getName(), sourceId, targetId, data.getActionId());
        Transitions.copyDataToTransition(data, transition);
        return transition;
    }

    public static void copyDataToTransition(TransitionData data, Transition transition) {
        transition.setDescription(data.getDescription());
        Transitions.copyScreenDataToTransition(data, transition);
        transition.setPropertiesCount(data.getPropertiesCount());
        transition.setConditionsCount(data.getConditionsCount());
        transition.setValidatorsCount(data.getValidatorsCount());
        transition.setPostFunctionsCount(data.getPostFunctionsCount());
    }
}

