/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.layout;

import com.atlassian.jira.plugins.workflowdesigner.layout.Layout;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutUpdater;
import com.atlassian.jira.plugins.workflowdesigner.layout.Status;
import com.atlassian.jira.plugins.workflowdesigner.layout.StatusCategory;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transition;
import com.atlassian.jira.plugins.workflowdesigner.layout.Transitions;
import com.atlassian.jira.plugins.workflowdesigner.layout.UpdateAuthor;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ActionDescriptorTransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.google.common.base.Objects;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.sysbliss.jira.plugins.workflow.util.WorkflowStatusUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class LayoutUpdaterImpl
implements LayoutUpdater {
    @Override
    public LayoutUpdater.UpdateResult updateLayoutWithDataFromWorkflow(Layout layout, JiraWorkflow workflow) {
        return new Updater(layout, workflow).update();
    }

    TransitionData createTransitionData(ActionDescriptor actionDescriptor) {
        return new ActionDescriptorTransitionData(actionDescriptor);
    }

    private static boolean stringValueHasChanged(String currentValue, String newValue) {
        return !Objects.equal((Object)StringUtils.stripToNull((String)currentValue), (Object)StringUtils.stripToNull((String)newValue));
    }

    private static Pair<Date, UpdateAuthor> resolveLatestUpdateDetails(JiraWorkflow workflow, Layout layout) {
        Date workflowUpdatedDate = workflow.getUpdatedDate();
        UpdateAuthor workflowUpdateAuthor = UpdateAuthor.fromApplicationUser(workflow.getUpdateAuthor());
        Date layoutUpdatedDate = layout.getUpdatedDate();
        UpdateAuthor layoutUpdateAuthor = layout.getUpdateAuthor();
        Pair result = workflowUpdatedDate == null ? Pair.nicePairOf((Object)layoutUpdatedDate, (Object)layoutUpdateAuthor) : (layoutUpdatedDate == null || workflowUpdatedDate.after(layoutUpdatedDate) ? Pair.nicePairOf((Object)workflowUpdatedDate, (Object)workflowUpdateAuthor) : Pair.nicePairOf((Object)layoutUpdatedDate, (Object)layoutUpdateAuthor));
        return result;
    }

    private static boolean updateDetailsChanged(Pair<Date, UpdateAuthor> currentUpdated, Pair<Date, UpdateAuthor> newUpdated) {
        return !Objects.equal(currentUpdated, newUpdated);
    }

    private class Updater {
        private boolean changed;
        private final Layout layout;
        private Layout newLayout = new Layout();
        private final List<StepDescriptor> steps;
        private final JiraWorkflow workflow;

        Updater(Layout layout, JiraWorkflow workflow) {
            this.layout = layout;
            this.steps = workflow.getDescriptor().getSteps();
            this.workflow = workflow;
        }

        LayoutUpdater.UpdateResult update() {
            this.deletedAndUpdatedSteps();
            this.addedSteps();
            this.deletedAndUpdatedTransitions();
            this.addedTransitions();
            this.addExistingGlobalTransitions();
            this.addUpdatedDateAndAuthor();
            return new LayoutUpdater.UpdateResult(this.changed, this.newLayout);
        }

        private void deletedAndUpdatedSteps() {
            for (Status status : this.layout.getStatuses()) {
                if (status.isInitial()) {
                    this.newLayout.addStatus(status);
                    continue;
                }
                boolean stillInWorkflow = false;
                for (StepDescriptor stepDescriptor : this.steps) {
                    String description;
                    String statusId;
                    String name;
                    if (status.getStepId() != stepDescriptor.getId()) continue;
                    com.atlassian.jira.issue.status.Status linkedStatus = this.workflow.getLinkedStatusObject(stepDescriptor);
                    String string = name = linkedStatus != null ? linkedStatus.getName() : stepDescriptor.getName();
                    if (LayoutUpdaterImpl.stringValueHasChanged(status.getName(), name)) {
                        status.setName(name);
                        this.changed = true;
                    }
                    String string2 = statusId = linkedStatus != null ? linkedStatus.getId() : null;
                    if (LayoutUpdaterImpl.stringValueHasChanged(status.getStatusId(), statusId)) {
                        status.setStatusId(statusId);
                        this.changed = true;
                    }
                    String string3 = description = linkedStatus != null ? linkedStatus.getDescription() : null;
                    if (LayoutUpdaterImpl.stringValueHasChanged(status.getDescription(), description)) {
                        status.setDescription(description);
                        this.changed = true;
                    }
                    StatusCategory statusCategory = this.getStatusCategoryForStatus(linkedStatus);
                    if (!Objects.equal((Object)status.getStatusCategory(), (Object)statusCategory)) {
                        status.setStatusCategory(statusCategory);
                        this.changed = true;
                    }
                    this.newLayout.addStatus(status);
                    stillInWorkflow = true;
                    break;
                }
                if (stillInWorkflow) continue;
                this.changed = true;
            }
        }

        private void addedSteps() {
            for (StepDescriptor stepDescriptor : this.steps) {
                boolean isNew = true;
                for (Status status : this.layout.getStatuses()) {
                    if (status.isInitial() || status.getStepId() != stepDescriptor.getId()) continue;
                    isNew = false;
                    break;
                }
                if (!isNew) continue;
                com.atlassian.jira.issue.status.Status linkedStatus = this.workflow.getLinkedStatusObject(stepDescriptor);
                this.newLayout.addStatus(new Status(this.createUIDForStep(stepDescriptor.getId()), linkedStatus != null ? linkedStatus.getName() : stepDescriptor.getName(), linkedStatus != null ? linkedStatus.getDescription() : null, false, stepDescriptor.getId(), linkedStatus != null ? linkedStatus.getId() : null, null, null, this.getStatusCategoryForStatus(linkedStatus)));
                this.changed = true;
            }
        }

        private StatusCategory getStatusCategoryForStatus(com.atlassian.jira.issue.status.Status status) {
            if (status == null) {
                return null;
            }
            com.atlassian.jira.issue.status.category.StatusCategory statusCategory = status.getStatusCategory();
            if (statusCategory == null) {
                return null;
            }
            return new StatusCategory(statusCategory.getColorName(), statusCategory.getId());
        }

        private String createUIDForStep(int stepId) {
            return String.format("S<%d>", stepId);
        }

        private void deletedAndUpdatedTransitions() {
            for (Transition transition : this.layout.getTransitions()) {
                boolean stillInWorkflow = false;
                for (ActionDescriptor actionDescriptor : this.workflow.getAllActions()) {
                    if (transition.getActionId() != actionDescriptor.getId() || !this.hasSourceId(actionDescriptor, transition.getSourceId())) continue;
                    int targetStepId = actionDescriptor.getUnconditionalResult().getStep();
                    String targetId = WorkflowStatusUtils.findStatusId(this.newLayout, targetStepId);
                    if (!transition.getTargetId().equals(targetId)) continue;
                    this.updateChangedData(actionDescriptor, transition);
                    String description = (String)actionDescriptor.getMetaAttributes().get("jira.description");
                    if (!Objects.equal((Object)transition.getDescription(), (Object)description)) {
                        transition.setDescription(description);
                        this.changed = true;
                    }
                    this.newLayout.addTransition(transition);
                    stillInWorkflow = true;
                    break;
                }
                if (stillInWorkflow) continue;
                this.changed = true;
            }
        }

        private void updateChangedData(ActionDescriptor actionDescriptor, Transition transition) {
            TransitionData data = LayoutUpdaterImpl.this.createTransitionData(actionDescriptor);
            if (Transitions.differentScreen(data, transition)) {
                Transitions.copyScreenDataToTransition(data, transition);
                this.changed = true;
            }
            if (!transition.getName().equals(actionDescriptor.getName())) {
                transition.setName(actionDescriptor.getName());
                this.changed = true;
            }
            int propertiesCount = data.getPropertiesCount();
            if (transition.getPropertiesCount() != propertiesCount) {
                transition.setPropertiesCount(propertiesCount);
                this.changed = true;
            }
            int conditionsCount = data.getConditionsCount();
            if (transition.getConditionsCount() != conditionsCount) {
                transition.setConditionsCount(conditionsCount);
                this.changed = true;
            }
            int validatorsCount = data.getValidatorsCount();
            if (transition.getValidatorsCount() != validatorsCount) {
                transition.setValidatorsCount(validatorsCount);
                this.changed = true;
            }
            int postFunctionsCount = data.getPostFunctionsCount();
            if (transition.getPostFunctionsCount() != postFunctionsCount) {
                transition.setPostFunctionsCount(postFunctionsCount);
                this.changed = true;
            }
        }

        private void addedTransitions() {
            Collection<ActionDescriptor> transitions = this.getTransitionsForLayoutRemovingGlobalTransitions();
            for (ActionDescriptor actionDescriptor : transitions) {
                int targetStepId = actionDescriptor.getUnconditionalResult().getStep();
                String targetId = WorkflowStatusUtils.findStatusId(this.newLayout, targetStepId);
                if (this.workflow.isInitialAction(actionDescriptor)) {
                    String sourceId = this.getInitialStepId();
                    this.checkNewTransitionCandidate(actionDescriptor, targetId, sourceId);
                    continue;
                }
                for (StepDescriptor step : this.steps) {
                    if (!step.getActions().contains(actionDescriptor)) continue;
                    String sourceId = WorkflowStatusUtils.findStatusId(this.newLayout, step.getId());
                    this.checkNewTransitionCandidate(actionDescriptor, targetId, sourceId);
                }
            }
        }

        private Collection<ActionDescriptor> getTransitionsForLayoutRemovingGlobalTransitions() {
            List globalTransitions = this.workflow.getDescriptor().getGlobalActions();
            return CollectionUtils.subtract((Collection)this.workflow.getAllActions(), (Collection)globalTransitions);
        }

        private void checkNewTransitionCandidate(ActionDescriptor actionDescriptor, String targetId, String sourceId) {
            boolean isNew = true;
            for (Transition transition : this.layout.getTransitions()) {
                if (transition.getActionId() != actionDescriptor.getId() || !transition.getSourceId().equals(sourceId) || !transition.getTargetId().equals(targetId)) continue;
                isNew = false;
                break;
            }
            if (isNew) {
                Transition transition;
                TransitionData data = LayoutUpdaterImpl.this.createTransitionData(actionDescriptor);
                transition = Transitions.create(data, sourceId, targetId);
                this.newLayout.addTransition(transition);
                this.changed = true;
            }
        }

        private String getInitialStepId() {
            for (Status status : this.newLayout.getStatuses()) {
                if (!status.isInitial()) continue;
                return status.getId();
            }
            throw new IllegalArgumentException("No initial status");
        }

        private boolean hasSourceId(ActionDescriptor actionDescriptor, String expectedSourceId) {
            if (this.workflow.isInitialAction(actionDescriptor)) {
                return expectedSourceId.equals(this.getInitialStepId());
            }
            for (StepDescriptor step : this.steps) {
                String sourceId;
                if (!step.getActions().contains(actionDescriptor) || !expectedSourceId.equals(sourceId = WorkflowStatusUtils.findStatusId(this.newLayout, step.getId()))) continue;
                return true;
            }
            return false;
        }

        private void addExistingGlobalTransitions() {
            for (Transition transition : this.layout.getTransitions()) {
                if (!transition.isGlobalTransition()) continue;
                this.newLayout.addTransition(transition);
            }
        }

        private void addUpdatedDateAndAuthor() {
            Pair latestUpdateDetails;
            Pair originalUpdateDetails = Pair.nicePairOf((Object)this.layout.getUpdatedDate(), (Object)this.layout.getUpdateAuthor());
            if (LayoutUpdaterImpl.updateDetailsChanged((Pair<Date, UpdateAuthor>)originalUpdateDetails, (Pair<Date, UpdateAuthor>)(latestUpdateDetails = LayoutUpdaterImpl.resolveLatestUpdateDetails(this.workflow, this.layout)))) {
                this.changed = true;
            }
            this.newLayout.setUpdatedDate((Date)latestUpdateDetails.first());
            this.newLayout.setUpdateAuthor((UpdateAuthor)latestUpdateDetails.second());
        }
    }
}

