/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.matcher;

import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.plugins.webhooks.listener.JiraWebHookListenerParameters;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.PluginModuleListenerParameters;
import java.util.Set;

public class IssueEventIdMatcher
implements EventMatcher<Object> {
    private final Set<Long> eventIds;

    public IssueEventIdMatcher(Set<Long> eventIds) {
        this.eventIds = eventIds;
    }

    public boolean matches(Object jiraEvent, Object consumerParams) {
        if (jiraEvent instanceof IssueEvent && consumerParams instanceof JiraWebHookListenerParameters) {
            IssueEvent issueEvent = (IssueEvent)jiraEvent;
            JiraWebHookListenerParameters jiraWebHookListenerParameters = (JiraWebHookListenerParameters)consumerParams;
            return this.eventIds.contains(issueEvent.getEventTypeId()) && jiraWebHookListenerParameters.getEventIds().contains(((IssueEvent)jiraEvent).getEventTypeId());
        }
        if (jiraEvent instanceof IssueEvent && consumerParams instanceof PluginModuleListenerParameters) {
            IssueEvent issueEvent = (IssueEvent)jiraEvent;
            PluginModuleListenerParameters pluginModuleConsumerParams = (PluginModuleListenerParameters)consumerParams;
            String webHookEventId = pluginModuleConsumerParams.getEventIdentifier();
            return WebHookJiraEvent.forEventName(webHookEventId).isPresent() && this.eventIds.contains(issueEvent.getEventTypeId()) && ((WebHookJiraEvent)((Object)WebHookJiraEvent.forEventName(webHookEventId).get())).getIssueEventIds().contains(((IssueEvent)jiraEvent).getEventTypeId());
        }
        return false;
    }
}

