/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks.matcher;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.plugins.webhooks.listener.JiraWebHookListenerParameters;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.PluginModuleListenerParameters;
import com.google.common.base.Optional;

public class IssueEventClassMatcher
implements EventMatcher<Object> {
    private final Class<? extends JiraEvent> eventClass;

    public IssueEventClassMatcher(Class<? extends JiraEvent> eventClass) {
        this.eventClass = eventClass;
    }

    public boolean matches(Object jiraEvent, Object consumerParams) {
        if (this.eventClass.isInstance(jiraEvent)) {
            if (consumerParams instanceof JiraWebHookListenerParameters) {
                return ((JiraWebHookListenerParameters)consumerParams).getEventClasses().contains(this.eventClass);
            }
            if (consumerParams instanceof PluginModuleListenerParameters) {
                String eventIdentifier = ((PluginModuleListenerParameters)consumerParams).getEventIdentifier();
                Optional<WebHookJiraEvent> webHookJiraEvent = WebHookJiraEvent.forEventName(eventIdentifier);
                return webHookJiraEvent.isPresent() && ((WebHookJiraEvent)((Object)webHookJiraEvent.get())).getEventClass().equals(this.eventClass);
            }
        }
        return false;
    }
}

