/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.webhooks;

import com.atlassian.jira.event.JiraEvent;
import com.atlassian.jira.plugins.webhooks.matcher.JqlEventMatcher;
import com.atlassian.jira.plugins.webhooks.matcher.WebHookJiraEvent;
import com.atlassian.jira.plugins.webhooks.serializer.JiraEventSerializerFactory;
import com.atlassian.jira.plugins.webhooks.workflow.WebHookPostFunctionEvent;
import com.atlassian.webhooks.spi.provider.EventMatcher;
import com.atlassian.webhooks.spi.provider.EventSerializerFactory;
import com.atlassian.webhooks.spi.provider.WebHookProvider;
import com.atlassian.webhooks.spi.provider.WebHookRegistrar;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

public class JiraWebHookProvider
implements WebHookProvider {
    private final JiraEventSerializerFactory eventSerializerFactory;
    private final JqlEventMatcher jqlEventMatcher;

    public JiraWebHookProvider(JiraEventSerializerFactory eventSerializerFactory, JqlEventMatcher jqlEventMatcher) {
        this.eventSerializerFactory = eventSerializerFactory;
        this.jqlEventMatcher = jqlEventMatcher;
    }

    public void provide(WebHookRegistrar publish) {
        for (WebHookJiraEvent webhooksJiraEvent : this.eventSerializerFactory.getWebhooksJiraEvents()) {
            Class<? extends JiraEvent> eventClass = webhooksJiraEvent.getEventClass();
            publish.webhook(webhooksJiraEvent.getValue()).whenFired(eventClass).matchedBy(JiraWebHookProvider.and(webhooksJiraEvent.getJiraEventMatcher(), this.jqlEventMatcher)).serializedWith((EventSerializerFactory)this.eventSerializerFactory);
        }
        publish.webhook("jira-webhook-post-function").whenFired(WebHookPostFunctionEvent.class).matchedBy((EventMatcher)new WebHookPostFunctionEvent.FunctionEventIdMatcher()).serializedWith((EventSerializerFactory)new WebHookPostFunctionEvent.FunctionEventSerializerFactory());
    }

    public static <T> EventMatcher<? super T> and(final EventMatcher<? super T> ... matchers) {
        return new EventMatcher<T>(){

            public boolean matches(final T event, final Object consumerParams) {
                return Iterables.all((Iterable)Lists.newArrayList((Object[])matchers), (Predicate)new Predicate<EventMatcher<? super T>>(){

                    public boolean apply(EventMatcher<? super T> matcher) {
                        return matcher.matches(event, consumerParams);
                    }
                });
            }
        };
    }
}

