/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.ConfigureData;
import com.atlassian.jira.projecttemplates.model.IssueTypeSchemeCreationResult;
import com.atlassian.jira.projecttemplates.model.IssueTypeScreenSchemeCreationResult;
import com.atlassian.jira.projecttemplates.model.WorkflowSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.CustomIssueTypeSchemeService;
import com.atlassian.jira.projecttemplates.service.CustomIssueTypeScreenSchemeService;
import com.atlassian.jira.projecttemplates.service.CustomResolutionService;
import com.atlassian.jira.projecttemplates.service.CustomWorkflowSchemeService;
import com.atlassian.jira.projecttemplates.service.ProjectConfigurationService;
import com.atlassian.jira.scheme.Scheme;
import java.util.ArrayList;
import java.util.Collection;

public class ProjectConfigurationServiceImpl
implements ProjectConfigurationService {
    private final CustomWorkflowSchemeService customWorkflowSchemeService;
    private final CustomIssueTypeSchemeService customIssueTypeSchemeService;
    private final CustomIssueTypeScreenSchemeService customIssueTypeScreenSchemeService;
    private final CustomResolutionService customResolutionService;

    public ProjectConfigurationServiceImpl(CustomWorkflowSchemeService customWorkflowSchemeService, CustomIssueTypeSchemeService customIssueTypeSchemeService, CustomIssueTypeScreenSchemeService customIssueTypeScreenSchemeService, CustomResolutionService customResolutionService) {
        this.customWorkflowSchemeService = customWorkflowSchemeService;
        this.customIssueTypeSchemeService = customIssueTypeSchemeService;
        this.customIssueTypeScreenSchemeService = customIssueTypeScreenSchemeService;
        this.customResolutionService = customResolutionService;
    }

    @Override
    public ConfigureData configure(Project project, ConfigTemplate configTemplate) {
        IssueTypeSchemeCreationResult issueTypeSchemeCreationResult = new IssueTypeSchemeCreationResult();
        WorkflowSchemeCreationResult workflowSchemeCreationResult = new WorkflowSchemeCreationResult();
        IssueTypeScreenSchemeCreationResult issueTypeScreenSchemeCreationResult = new IssueTypeScreenSchemeCreationResult();
        Collection<Resolution> resolutions = new ArrayList<Resolution>();
        if (configTemplate != null) {
            issueTypeSchemeCreationResult = this.customIssueTypeSchemeService.configureCustomIssueTypeSchemeForProjectFromTemplate(project, configTemplate);
            workflowSchemeCreationResult = this.customWorkflowSchemeService.configureCustomWorkflowSchemeForProjectFromTemplate(project, configTemplate, issueTypeSchemeCreationResult.getCreatedIssueTypes());
            issueTypeScreenSchemeCreationResult = this.customIssueTypeScreenSchemeService.configureIssueTypeScreenScheme(project, configTemplate, issueTypeSchemeCreationResult.getCreatedIssueTypes());
            resolutions = this.customResolutionService.configureResolutions(configTemplate.resolutionTemplates());
        }
        return this.createConfigureData(project, workflowSchemeCreationResult, issueTypeSchemeCreationResult, issueTypeScreenSchemeCreationResult, resolutions);
    }

    private ConfigureData createConfigureData(Project project, WorkflowSchemeCreationResult workflowResult, IssueTypeSchemeCreationResult issueTypeResult, IssueTypeScreenSchemeCreationResult issueTypeScreenSchemeCreationResult, Collection<Resolution> resolutions) {
        return ConfigureData.create((Project)project, (Scheme)workflowResult.getCreatedWorklowScheme(), workflowResult.getCreatedWorkflows(), (FieldConfigScheme)issueTypeResult.getCreatedIssueTypeScheme(), issueTypeResult.getCreatedIssueTypes(), (IssueTypeScreenScheme)issueTypeScreenSchemeCreationResult.getCreatedIssueTypeScreenScheme(), issueTypeScreenSchemeCreationResult.getCreatedScreenSchemes(), issueTypeScreenSchemeCreationResult.getCreatedScreens(), resolutions);
    }
}

