/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.service;

import com.atlassian.jira.blueprint.template.I18nTranslator;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenFactory;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.template.hook.ConfigTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeScreenSchemeTemplate;
import com.atlassian.jira.project.template.hook.IssueTypeTemplate;
import com.atlassian.jira.project.template.hook.ScreenSchemeTemplate;
import com.atlassian.jira.project.template.hook.ScreenTemplate;
import com.atlassian.jira.projecttemplates.model.IssueTypeScreenSchemeCreationResult;
import com.atlassian.jira.projecttemplates.service.CustomIssueTypeScreenSchemeService;
import com.atlassian.jira.projecttemplates.service.CustomScreenSchemeService;
import com.atlassian.jira.projecttemplates.service.CustomScreenService;
import com.atlassian.jira.projecttemplates.service.NameResolver;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class CustomIssueTypeScreenSchemeServiceImpl
implements CustomIssueTypeScreenSchemeService {
    private final CustomScreenService customScreenService;
    private final CustomScreenSchemeService customScreenSchemeService;
    private final FieldScreenFactory fieldScreenFactory;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final I18nTranslator i18nTranslator;
    private final NameResolver nameResolver;

    public CustomIssueTypeScreenSchemeServiceImpl(CustomScreenService customScreenService, CustomScreenSchemeService customScreenSchemeService, FieldScreenFactory fieldScreenFactory, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, I18nTranslator i18nTranslator, NameResolver nameResolver) {
        this.customScreenService = customScreenService;
        this.customScreenSchemeService = customScreenSchemeService;
        this.fieldScreenFactory = fieldScreenFactory;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.i18nTranslator = i18nTranslator;
        this.nameResolver = nameResolver;
    }

    @Override
    public IssueTypeScreenSchemeCreationResult configureIssueTypeScreenScheme(Project project, ConfigTemplate configTemplate, Map<String, IssueType> issueTypes) {
        if (!configTemplate.issueTypeScreenSchemeTemplate().isPresent()) {
            return new IssueTypeScreenSchemeCreationResult();
        }
        IssueTypeScreenSchemeTemplate template = (IssueTypeScreenSchemeTemplate)configTemplate.issueTypeScreenSchemeTemplate().get();
        Map<String, FieldScreen> screens = this.createScreens(project.getKey(), template);
        Map<String, FieldScreenScheme> screenSchemes = this.createScreenSchemes(project.getKey(), template, screens);
        IssueTypeScreenScheme issueTypeScreenScheme = this.createIssueTypeScreenScheme(project.getKey(), template, screenSchemes, configTemplate, issueTypes);
        this.issueTypeScreenSchemeManager.addSchemeAssociation(project, issueTypeScreenScheme);
        return new IssueTypeScreenSchemeCreationResult(issueTypeScreenScheme, screenSchemes, screens);
    }

    private Map<String, FieldScreen> createScreens(String projectKey, IssueTypeScreenSchemeTemplate template) {
        HashMap screens = Maps.newHashMap();
        for (ScreenTemplate screenTemplate : template.screenTemplates()) {
            FieldScreen screen = this.customScreenService.create(projectKey, screenTemplate);
            screens.put(screenTemplate.key(), screen);
        }
        return screens;
    }

    private Map<String, FieldScreenScheme> createScreenSchemes(String projectKey, IssueTypeScreenSchemeTemplate template, Map<String, FieldScreen> screens) {
        HashMap screenSchemes = Maps.newHashMap();
        for (ScreenSchemeTemplate screenSchemeTemplate : template.screenSchemeTemplates()) {
            FieldScreenScheme screenScheme = this.customScreenSchemeService.create(projectKey, screenSchemeTemplate, screens);
            screenSchemes.put(screenSchemeTemplate.key(), screenScheme);
        }
        return screenSchemes;
    }

    private IssueTypeScreenScheme createIssueTypeScreenScheme(String projectKey, IssueTypeScreenSchemeTemplate template, Map<String, FieldScreenScheme> screenSchemes, ConfigTemplate configTemplate, Map<String, IssueType> issueTypes) {
        IssueTypeScreenScheme scheme = this.fieldScreenFactory.createIssueTypeScreenScheme();
        String name = this.nameResolver.getUniqueName(projectKey, template.name(), new IsScreenSchemeNameUnique());
        String description = this.i18nTranslator.getSystemTranslation(template.description());
        scheme.setName(name);
        scheme.setDescription(description);
        scheme.store();
        this.addSchemeEntity(scheme, template.defaultScreenScheme(), null, screenSchemes);
        if (configTemplate.issueTypeSchemeTemplate().isPresent()) {
            for (IssueTypeTemplate issueTypeTemplate : ((IssueTypeSchemeTemplate)configTemplate.issueTypeSchemeTemplate().get()).issueTypeTemplates()) {
                Optional screenSchemeKey = issueTypeTemplate.screenScheme();
                if (!screenSchemeKey.isPresent()) continue;
                IssueType issueType = issueTypes.get(issueTypeTemplate.key());
                this.addSchemeEntity(scheme, (String)screenSchemeKey.get(), issueType.getId(), screenSchemes);
            }
        }
        return scheme;
    }

    private void addSchemeEntity(IssueTypeScreenScheme scheme, String screenSchemeKey, String issueTypeId, Map<String, FieldScreenScheme> screenSchemes) {
        FieldScreenScheme screenScheme = screenSchemes.get(screenSchemeKey);
        IssueTypeScreenSchemeEntity entity = this.fieldScreenFactory.createIssueTypeScreenSchemeEntity();
        entity.setIssueTypeId(issueTypeId);
        entity.setFieldScreenScheme(screenScheme);
        scheme.addEntity(entity);
    }

    private class IsScreenSchemeNameUnique
    implements Predicate<String> {
        private IsScreenSchemeNameUnique() {
        }

        public boolean apply(String name) {
            for (IssueTypeScreenScheme scheme : CustomIssueTypeScreenSchemeServiceImpl.this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (!name.equals(scheme.getName())) continue;
                return false;
            }
            return true;
        }
    }
}

