/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.blueprint.service;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.workflow.WorkflowConditionDescriptorFactory;
import com.atlassian.jira.bc.workflow.WorkflowFunctionDescriptorFactory;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.bc.workflow.WorkflowTransitionService;
import com.atlassian.jira.blueprint.api.ProjectCreateHookHelper;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;

public class ProjectCreateHookHelperImpl
implements ProjectCreateHookHelper {
    public static final String DEFAULT_STATUS_URL = "/images/icons/status_generic.gif";
    private final ConstantsManager constantsManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ResolutionManager resolutionManager;
    private final StatusManager statusManager;
    private final WorkflowService workflowService;
    private final WorkflowTransitionService workflowTransitionService;
    private final WorkflowConditionDescriptorFactory workflowConditionDescriptorFactory;
    private final WorkflowFunctionDescriptorFactory workflowFunctionDescriptorFactory;

    public ProjectCreateHookHelperImpl(ConstantsManager constantsManager, JiraAuthenticationContext jiraAuthenticationContext, ResolutionManager resolutionManager, StatusManager statusManager, WorkflowService workflowService, WorkflowTransitionService workflowTransitionService, WorkflowConditionDescriptorFactory workflowConditionDescriptorFactory, WorkflowFunctionDescriptorFactory workflowFunctionDescriptorFactory) {
        this.constantsManager = constantsManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.resolutionManager = resolutionManager;
        this.statusManager = statusManager;
        this.workflowService = workflowService;
        this.workflowTransitionService = workflowTransitionService;
        this.workflowConditionDescriptorFactory = workflowConditionDescriptorFactory;
        this.workflowFunctionDescriptorFactory = workflowFunctionDescriptorFactory;
    }

    public void overrideDefaultIconsFor(ProjectCreateHookHelper.StatusIcon ... statusesToUpdate) {
        for (ProjectCreateHookHelper.StatusIcon statusToUpdate : statusesToUpdate) {
            Status status = this.constantsManager.getStatusByName(statusToUpdate.getStatusName());
            if (null == status || !DEFAULT_STATUS_URL.equals(status.getIconUrl())) continue;
            this.statusManager.editStatus(status, status.getName(), status.getDescription(), statusToUpdate.getNewUrl());
        }
    }

    public Resolution retrieveOrCreateResolution(String name, String description) {
        Resolution resolution = this.resolutionManager.getResolutionByName(name);
        return resolution == null ? this.resolutionManager.createResolution(name, description) : resolution;
    }

    public void addResolutionValuePostFunction(String value, JiraWorkflow jiraWorkflow, String actionName) {
        this.workflowTransitionService.addPostFunctionToWorkflow(actionName, this.workflowFunctionDescriptorFactory.updateIssueField("resolution", value), jiraWorkflow);
    }

    public void addPermissionCondition(ProjectPermissionKey permission, JiraWorkflow jiraWorkflow, String actionName) {
        this.workflowTransitionService.addConditionToWorkflow(actionName, this.workflowConditionDescriptorFactory.permission(permission), jiraWorkflow);
    }

    public void applyWorkflowChanges(JiraWorkflow jiraWorkflow) {
        if (jiraWorkflow != null) {
            this.workflowService.overwriteActiveWorkflow(this.getJiraServiceContext(), jiraWorkflow.getName());
        }
    }

    protected JiraServiceContext getJiraServiceContext() {
        return new JiraServiceContextImpl(this.jiraAuthenticationContext.getUser(), (ErrorCollection)new SimpleErrorCollection());
    }
}

