JPT.SelectProjectTemplateController = {};

JPT.SelectProjectTemplateController.init = function init(projectTemplates, itemModuleCompleteKey) {
    // We hide + show the dialog and draw the SelectProjectTemplateView all the time, as that draws the buttons required.
    JPT.DialogController.$dialogElement.hide();
    JPT.SelectProjectTemplateView.draw(projectTemplates);
    if (itemModuleCompleteKey) {
        var selectedProjectTemplate = _.find(projectTemplates, function (pt) {
            return pt.itemModuleCompleteKey === itemModuleCompleteKey;
        });

        if (!_.isUndefined(selectedProjectTemplate)) {
            JPT.SelectProjectTemplateController.openAddProjectPage(selectedProjectTemplate);
        } else {
            JPT.DialogView.showErrorMessage(AJS.I18n.getText("add.projects.templates.error.invalidtemplaterequested"));
            JPT.SelectProjectTemplateView.disableNextButton();
        }
    }

    JPT.DialogController.$dialogElement.show();

    JPT.SelectProjectTemplateView.truncateTemplateDescriptions();
};

/**
 * Return a Promise that others can hook into that returns the data required.
 */
JPT.SelectProjectTemplateController.loadProjectTemplatesData = function loadProjectTemplatesData() {
    // Perform AJAX request for web items in the dialog and return them.
    return AJS.$.ajax({
        url: contextPath + "/rest/project-templates/1.0/templates",
        type: "GET",
        timeout: 5000
    });
};

JPT.SelectProjectTemplateController.dialogSubmitted = function dialogSubmitted() {
    var projectTemplateData = JPT.SelectProjectTemplateView.getSelectedTemplateData();

    JPT.DialogController.hideDialogFromNewUser("templateselected");

    JPT.SelectProjectTemplateController.raiseAtlassianEvent(projectTemplateData.itemModuleCompleteKey);

    if (!_.isUndefined(projectTemplateData.infoSoyPath)) {
        JPT.TemplateInfoController = new JPT.TemplateInfoControllerImpl();
        JPT.TemplateInfoController.initTemplateInfo(projectTemplateData);
    } else {
        JPT.SelectProjectTemplateController.openAddProjectPage(projectTemplateData);
    }
};

JPT.SelectProjectTemplateController.openAddProjectPage = function openAddProjectPage(projectTemplateData) {
    if (!projectTemplateData) {
        // Null data? How did you get here? It should be impossible to have no selected item.
        JPT.DialogView.showErrorMessage(AJS.I18n.getText("add.projects.templates.error.requestfailed.msg"));
        return;
    }

    // Should the template key be missing, go to the project configuration step
    if (projectTemplateData.createProject) {
        JPT.AddProjectController.initProjectTemplate(projectTemplateData);
        // Otherwise, no template key provided: fire an event passing the dialog, so the plugin can choose what to do next
    } else {
        JPT.DialogController.dialog.addPage("blank-template-page");
        AJS.$("body").trigger(projectTemplateData.itemModuleCompleteKey, JPT.DialogController.dialog);
    }
};

JPT.SelectProjectTemplateController.raiseAtlassianEvent = function raiseAtlassianEvent(projectTemplateModuleKey) {
    JPT.ConfigModel.selectedTemplate = projectTemplateModuleKey;
    if (AJS.EventQueue) {
        AJS.EventQueue.push({
            name: "projecttemplates.templateselected",
            properties: {
                selectedTemplate: projectTemplateModuleKey
            }
        });
    }
};
