JPT.ProjectKeyGenerator = {};

JPT.ProjectKeyGenerator.IGNORED_WORDS = ["THE", "A", "AN", "AS", "AND", "OF", "OR"];

// The (non-ascii) characters used as keys will be replaced with their (ascii) value.
JPT.ProjectKeyGenerator.CHARACTER_MAP = {};
JPT.ProjectKeyGenerator.CHARACTER_MAP[199] = "C"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[231] = "c"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[252] = "u"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[251] = "u"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[250] = "u"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[249] = "u"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[233] = "e"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[234] = "e"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[235] = "e"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[232] = "e"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[226] = "a"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[228] = "a"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[224] = "a"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[229] = "a"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[225] = "a"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[239] = "i"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[238] = "i"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[236] = "i"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[237] = "i"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[196] = "A"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[197] = "A"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[201] = "E"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[230] = "ae"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[198] = "Ae"; // ®
JPT.ProjectKeyGenerator.CHARACTER_MAP[244] = "o"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[246] = "o"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[242] = "o"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[243] = "o"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[220] = "U"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[255] = "Y"; // Ø
JPT.ProjectKeyGenerator.CHARACTER_MAP[214] = "O"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[241] = "n"; // ?
JPT.ProjectKeyGenerator.CHARACTER_MAP[209] = "N"; // ?

JPT.ProjectKeyGenerator.desiredKeyLength = 4;
JPT.ProjectKeyGenerator.maxKeyLength = 10;

JPT.ProjectKeyGenerator.getTotalLength = function getTotalLength(words) {
    return words.join("").length;
};

JPT.ProjectKeyGenerator.removeIgnoredWords = function removeIgnoredWords(words) {
    return _.reject(words, function(word) {
        return AJS.$.inArray(word, JPT.ProjectKeyGenerator.IGNORED_WORDS) !== -1;
    });
};

JPT.ProjectKeyGenerator.createAcronym = function createAcronym(words) {
    var result = "";
    AJS.$.each(words, function(i, word) {
        result += word.charAt(0);
    });
    return result;
};

JPT.ProjectKeyGenerator.getFirstSyllable = function getFirstSyllable(word) {
    // Best guess at getting the first syllable
    // Returns the substring up to and including the first consonant to appear after a vowel
    var pastVowel = false;
    var i;
    for (i = 0; i < word.length; i++) {
        if (JPT.ProjectKeyGenerator.isVowelOrY(word[i])) {
            pastVowel = true;
        } else {
            if (pastVowel) {
                return word.substring(0, i + 1);
            }
        }
    }
    return word;
};

JPT.ProjectKeyGenerator.isVowelOrY = function isVowelOrY(c) {
    return c && c.length === 1 && c.search("[AEIOUY]") !== -1;
};

JPT.ProjectKeyGenerator.init = function init(desiredKeyLength, maxKeyLength) {
    JPT.ProjectKeyGenerator.desiredKeyLength = desiredKeyLength;
    JPT.ProjectKeyGenerator.maxKeyLength = maxKeyLength;
};

JPT.ProjectKeyGenerator.generate = function generate(name) {
    name = AJS.$.trim(name);
    if (!name) {
        return "";
    }

    // Brute-force chunk-by-chunk substitution and filtering.
    var filtered = [];
    for(var i=0, ii=name.length; i<ii; i++) {
        var sub = JPT.ProjectKeyGenerator.CHARACTER_MAP[name.charCodeAt(i)];
        filtered.push(sub ? sub : name[i]);
    }
    name = filtered.join('');

    // Split into words
    var words = [];
    AJS.$.each(name.split(/\s+/), function(i, word) {
        if (word) {
            // Remove whitespace and punctuation characters (i.e. anything not A-Z)
            word = word.replace(/[^a-zA-Z]/g, "");
            // uppercase the word (NOTE: JavaScript attempts to convert characters like § in to SS)
            word = word.toUpperCase();
            // add the word, should it be worthy.
            word.length && words.push(word);
        }
    });

    // Remove ignored words
    if (JPT.ProjectKeyGenerator.desiredKeyLength && JPT.ProjectKeyGenerator.getTotalLength(words) > JPT.ProjectKeyGenerator.desiredKeyLength) {
        words = JPT.ProjectKeyGenerator.removeIgnoredWords(words);
    }

    var key;

    if (words.length == 0) {
        // No words were worthy!
        key = "";
    } else if (words.length == 1) {
        // If we have one word, and it is longer than a desired key, get the first syllable
        var word = words[0];
        if (JPT.ProjectKeyGenerator.desiredKeyLength && word.length > JPT.ProjectKeyGenerator.desiredKeyLength) {
            key = JPT.ProjectKeyGenerator.getFirstSyllable(word);
        } else {
            // The word is short enough to use as a key
            key = word;
        }
    } else {
        // If we have more than one word, just take the first letter from each
        key = JPT.ProjectKeyGenerator.createAcronym(words);
    }

    // Limit the length of the key
    if (JPT.ProjectKeyGenerator.maxKeyLength && key.length > JPT.ProjectKeyGenerator.maxKeyLength) {
        key = key.substr(0, JPT.ProjectKeyGenerator.maxKeyLength);
    }

    return key;
};