/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.rest;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projecttemplates.model.ApplyTemplateParam;
import com.atlassian.jira.projecttemplates.model.ProjectTemplate;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateDialogData;
import com.atlassian.jira.projecttemplates.model.ProjectTemplateInstantiationResult;
import com.atlassian.jira.projecttemplates.service.ProjectTemplateService;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ValidationFailureException;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="templates")
public class ProjectTemplatesResource {
    private final ProjectTemplateService projectTemplateService;
    private final ProjectService projectService;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authContext;
    private final UserManager userManager;
    private final JiraLicenseService licenseService;
    private final AvatarService avatarService;

    public ProjectTemplatesResource(ProjectTemplateService projectTemplateService, ProjectService projectService, ProjectManager projectManager, JiraAuthenticationContext authContext, UserManager userManager, JiraLicenseService licenseService, AvatarService avatarService) {
        this.projectTemplateService = projectTemplateService;
        this.projectService = projectService;
        this.projectManager = projectManager;
        this.authContext = authContext;
        this.userManager = userManager;
        this.licenseService = licenseService;
        this.avatarService = avatarService;
    }

    @GET
    @Produces(value={"application/json"})
    @WebSudoRequired
    public Response getProjectTemplates() {
        List<ProjectTemplate> webItems = this.projectTemplateService.getProjectTemplateItems(this.authContext.getUser().getDirectoryUser());
        ApplicationUser defaultLead = this.getDefaultLead();
        ProjectTemplateDialogData data = new ProjectTemplateDialogData.Builder().projectTemplates(webItems).maxKeyLength(this.projectService.getMaximumKeyLength()).minNameLength(2).maxNameLength(this.projectService.getMaximumNameLength()).shouldShowProjectLead(this.userManager.getTotalUserCount() > 1 || !this.authContext.isLoggedInUser()).serverId(this.licenseService.getServerId()).currentUserName(defaultLead.getUsername()).currentUserDisplayName(defaultLead.getDisplayName()).currentUserAvatarUrl(this.getDefaultLeadAvatarUrl()).projectCount(this.getProjectCount()).build();
        return Response.ok((Object)data).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @WebSudoRequired
    @RequiresXsrfCheck
    public Response createProjectFromFormRequest(@FormParam(value="name") String name, @FormParam(value="key") String key, @FormParam(value="lead") String leadName, @FormParam(value="projectTemplateWebItemKey") String projectTemplateWebItemKey, @Context HttpServletRequest request) {
        Map requestParams = request.getParameterMap();
        if (this.userManager.getTotalUserCount() == 1) {
            leadName = this.getDefaultLead().getUsername();
        }
        ApplicationUser currentUser = this.authContext.getUser();
        ApplyTemplateParam applyTemplateParam = ApplyTemplateParam.create().setCurrentUser(currentUser).setProjectName(name).setProjectKey(key.toUpperCase()).setProjectDescription(this.getDescription()).setLeadName(leadName).setUrl(this.getUrl()).setProjectTemplateWebItemKey(projectTemplateWebItemKey).setTemplateConfigurationParams(requestParams);
        try {
            ProjectTemplateInstantiationResult templateInstantiationResult = this.projectTemplateService.applyProjectTemplate(applyTemplateParam);
            return Response.ok((Object)templateInstantiationResult).build();
        }
        catch (ValidationFailureException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)e.errors())).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)e).build());
        }
    }

    private String getDescription() {
        return "";
    }

    private String getUrl() {
        return "";
    }

    private ApplicationUser getDefaultLead() {
        ApplicationUser user = this.authContext.getUser();
        return user != null ? user : null;
    }

    private String getDefaultLeadAvatarUrl() {
        return this.avatarService.getAvatarURL(ApplicationUsers.toDirectoryUser((ApplicationUser)this.authContext.getUser()), this.authContext.getUser().getUsername(), Avatar.Size.SMALL).toString();
    }

    private long getProjectCount() {
        return this.projectManager.getProjectCount();
    }
}

