/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projecttemplates.manager.legacy;

import com.atlassian.jira.blueprint.api.AddProjectHook;
import com.atlassian.jira.blueprint.api.ConfigureData;
import com.atlassian.jira.blueprint.api.ConfigureResponse;
import com.atlassian.jira.blueprint.api.ValidateData;
import com.atlassian.jira.blueprint.api.ValidateResponse;
import com.atlassian.jira.projecttemplates.ProjectCreateHook;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class ProjectCreateHookAdapter
implements AddProjectHook {
    private final ProjectCreateHook projectCreateHook;

    public ProjectCreateHookAdapter(ProjectCreateHook projectCreateHook) {
        this.projectCreateHook = projectCreateHook;
    }

    public ValidateResponse validate(ValidateData validate) {
        if (this.projectCreateHook != null) {
            HashMap requestParams = Maps.newHashMap();
            requestParams.put("name", new String[]{validate.projectName()});
            requestParams.put("key", new String[]{validate.projectKey()});
            ApplicationUser lead = validate.lead();
            if (lead != null) {
                requestParams.put("lead", new String[]{lead.getKey()});
            }
            return this.toBeforeAddResponse(this.projectCreateHook.validateCreateProject((Map)requestParams));
        }
        return ValidateResponse.create();
    }

    public ConfigureResponse configure(ConfigureData configure) {
        if (this.projectCreateHook != null) {
            HashMap requestParams = Maps.newHashMap();
            requestParams.put("name", new String[]{configure.project().getName()});
            requestParams.put("key", new String[]{configure.project().getKey()});
            requestParams.put("lead", new String[]{configure.project().getLeadUserKey()});
            return this.toAfterAddResponse(this.projectCreateHook.configureProjectThenRedirect(configure.project(), (Map)requestParams));
        }
        return ConfigureResponse.create();
    }

    private ConfigureResponse toAfterAddResponse(String redirectTo) {
        ConfigureResponse configureResponse = ConfigureResponse.create();
        if (StringUtils.isNotBlank((CharSequence)redirectTo)) {
            configureResponse.setRedirect(redirectTo);
        }
        return configureResponse;
    }

    private ValidateResponse toBeforeAddResponse(ErrorCollection errors) {
        ValidateResponse response = ValidateResponse.create();
        for (String string : errors.getErrorMessages()) {
            response.addErrorMessage(string);
        }
        for (Map.Entry entry : errors.getErrors().entrySet()) {
            response.addError((String)entry.getKey(), (String)entry.getValue());
        }
        return response;
    }
}

